/*
 * Decompiled with CFR 0.152.
 */
package jedas.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jedas.utils.ComponentModifier;

public class DialogDesigner
extends Frame {
    ComponentModifier modi;
    public static ComponentPanel cPanel;

    public static void main(String[] args) {
        System.out.println("jedas.util.DialogDesigner");
        System.out.println("=========================");
        System.out.println();
        System.out.println("Key mappings:");
        System.out.println("       L - insert a label");
        System.out.println("       B - insert a button");
        System.out.println("       T - insert a text field");
        System.out.println("       E - export source code to stdout");
        System.out.println("  Arrows - move component");
        System.out.println("    +Alt - resize component");
        System.out.println("   +Ctrl - set increment to 10");
        System.out.println();
        System.out.println("Click a component to select.");
        System.out.println("-------------------------");
        new DialogDesigner();
    }

    public DialogDesigner() {
        super("Jedas Dialog Designer");
        this.setLayout(new BorderLayout());
        ComponentPanel cp = new ComponentPanel();
        this.add((Component)cp, "Center");
        this.modi = new ComponentModifier(cp);
        cPanel = cp;
        cp.addKeyListener(this.modi);
        this.pack();
        this.setVisible(true);
    }

    protected class ComponentPanel
    extends Panel {
        Dimension mySize;

        public ComponentPanel() {
            this.setLayout(null);
            this.mySize = new Dimension(400, 400);
            this.addMouseListener(new ComponentFetcher());
        }

        public Component add(Component newComp) {
            Component tmp = super.add(newComp);
            System.out.println("Added a " + newComp.toString());
            tmp.addMouseListener(new ComponentFetcher());
            tmp.addKeyListener(DialogDesigner.this.modi);
            DialogDesigner.this.modi.comps.addElement(newComp);
            return tmp;
        }

        public Dimension getPreferredSize() {
            return this.mySize;
        }
    }

    private class ComponentFetcher
    extends MouseAdapter {
        private ComponentFetcher() {
        }

        public void mouseClicked(MouseEvent e) {
            DialogDesigner.this.modi.setComponent(e.getComponent());
        }
    }
}

