/*
 * Decompiled with CFR 0.152.
 */
package jedas.utils;

import java.awt.Color;
import java.awt.Toolkit;
import jedas.DPair;

public class Misc {
    private static int[] colors = new int[]{0, 255, 65280, 65535, 0xFF0000, 0xFF00FF, 0xFFFF00, 0xFFFFFF, 150, 182, 215, 8835071, 37376, 45568, 54016, 37526, 45750, 54231, 0x960000, 0xB60000, 0xD70000, 0x960096, 0xB600B6, 0xD700D7, 8794112, 10895616, 13066496, 16745094, 16753318, 16761799, 16770023, 16766720};
    private static int RED_MASK = 0xFF0000;
    private static int GREEN_MASK = 65280;
    private static int BLUE_MASK = 255;

    public static Color cloneColor(Color c) {
        if (c != null) {
            return new Color(c.getRed(), c.getGreen(), c.getBlue());
        }
        return null;
    }

    public static DPair cloneDPair(DPair pair) {
        if (pair == null) {
            return null;
        }
        DPair np = (DPair)pair.clone();
        return np;
    }

    public static DPair[] cloneDPairs(DPair[] pairs) {
        if (pairs == null) {
            return null;
        }
        DPair[] np = new DPair[pairs.length];
        int i = 0;
        while (i < pairs.length) {
            np[i] = (DPair)pairs[i].clone();
            ++i;
        }
        return np;
    }

    public static String[] getFontNames() {
        Toolkit defTk = Toolkit.getDefaultToolkit();
        String[] fonts = defTk.getFontList();
        return fonts;
    }

    public static int getXFigColor(Color color) {
        if (color == null) {
            return -1;
        }
        int cred = color.getRed();
        int cgreen = color.getGreen();
        int cblue = color.getBlue();
        int xfig_color = 0;
        int xfig_best_color = Integer.MAX_VALUE;
        int i = 0;
        while (i < colors.length) {
            int xred = (colors[i] & RED_MASK) >> 16;
            int xgreen = (colors[i] & GREEN_MASK) >> 8;
            int xblue = colors[i] & BLUE_MASK;
            int cscore = Math.abs(xred - cred) + Math.abs(xgreen - cgreen) + Math.abs(xblue - cblue);
            if (cscore < xfig_best_color) {
                xfig_best_color = cscore;
                xfig_color = i;
            }
            ++i;
        }
        return xfig_color;
    }

    public static void sortStrings(String[] stringArray) {
        int i = 0;
        while (i < stringArray.length) {
            String smallest = stringArray[i];
            int smallestIndex = i;
            int j = i + 1;
            while (j < stringArray.length) {
                if (smallest.compareTo(stringArray[j]) > 0) {
                    smallest = stringArray[j];
                    smallestIndex = j;
                }
                ++j;
            }
            if (smallestIndex != i) {
                String temp = stringArray[i];
                stringArray[i] = stringArray[smallestIndex];
                stringArray[smallestIndex] = temp;
            }
            ++i;
        }
    }
}

