/*
 * Decompiled with CFR 0.152.
 */
package jedas.utils;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jedas.Jedas;

public class PreferencesDialog
extends Frame {
    private static boolean instanciated = false;
    private static final String APPLY = "Apply";
    private static final String CANCEL = "Cancel";
    private SettingsPanel panel;
    private PreferencesDialog instance = null;

    public PreferencesDialog() throws Exception {
        super("Jedas settings");
        if (instanciated) {
            this.instance.toFront();
            throw new Exception("PreferenceDialog::already instanciated");
        }
        instanciated = true;
        this.setLayout(new BorderLayout());
        this.panel = new SettingsPanel();
        this.add((Component)this.panel, "Center");
        this.addWindowListener(new CloseListener());
        this.instance = this;
        this.pack();
        this.setVisible(true);
    }

    void closeWindow() {
        instanciated = false;
        this.instance = null;
        this.dispose();
    }

    void applySettings() {
        try {
            int newDelay = Integer.parseInt(this.panel.frameDelay.getText());
            Jedas.getScheduler().setDelay(newDelay);
        }
        catch (Exception e) {
            System.err.println("PreferencesDialog::applySettings() " + e.toString());
        }
        try {
            int newInActDelay;
            Jedas.TRANSITION_DELAY = newInActDelay = Integer.parseInt(this.panel.transDelay.getText());
        }
        catch (Exception e) {
            System.err.println("PreferencesDialog::applySettings() " + e.toString());
        }
        try {
            int attrCh;
            Jedas.MAX_ABS_TRANS = attrCh = Integer.parseInt(this.panel.maxTrans.getText());
        }
        catch (Exception e) {
            System.err.println("PreferencesDialog::applySettings() " + e.toString());
        }
        Jedas.COMPRESS_OUTPUT = this.panel.compressBox_.getState();
        this.closeWindow();
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String tmp = e.getActionCommand();
            if (tmp.equals(PreferencesDialog.APPLY)) {
                PreferencesDialog.this.applySettings();
            } else if (tmp.equals(PreferencesDialog.CANCEL)) {
                PreferencesDialog.this.closeWindow();
            }
        }
    }

    private class SettingsPanel
    extends Panel {
        Label label0;
        public TextField frameDelay;
        Label label1;
        Label label2;
        public TextField transDelay;
        Label label3;
        Label label4;
        public TextField maxTrans;
        Label label5;
        Button button0;
        Button button1;
        Checkbox compressBox_;

        public SettingsPanel() {
            this.setLayout(null);
            this.label0 = new Label("Minimum frame delay:");
            this.label0.setLocation(20, 20);
            this.label0.setSize(140, 15);
            this.add(this.label0);
            this.frameDelay = Jedas.getScheduler() != null ? new TextField("" + Jedas.getScheduler().getDelay()) : new TextField("40");
            this.frameDelay.setLocation(180, 12);
            this.frameDelay.setSize(80, 30);
            this.add(this.frameDelay);
            this.label1 = new Label("Complete Transitions settings:");
            this.label1.setLocation(20, 50);
            this.label1.setSize(210, 15);
            this.add(this.label1);
            this.label2 = new Label("Close after");
            this.label2.setLocation(40, 80);
            this.label2.setSize(80, 15);
            this.add(this.label2);
            this.transDelay = new TextField("" + Jedas.TRANSITION_DELAY);
            this.transDelay.setLocation(130, 73);
            this.transDelay.setSize(80, 30);
            this.add(this.transDelay);
            this.label3 = new Label("ms of inactivity");
            this.label3.setLocation(210, 80);
            this.label3.setSize(100, 15);
            this.add(this.label3);
            this.label4 = new Label("or after");
            this.label4.setLocation(40, 110);
            this.label4.setSize(80, 15);
            this.add(this.label4);
            this.maxTrans = new TextField("" + Jedas.MAX_ABS_TRANS);
            this.maxTrans.setLocation(130, 103);
            this.maxTrans.setSize(80, 30);
            this.add(this.maxTrans);
            this.label5 = new Label("attribute changes");
            this.label5.setLocation(210, 110);
            this.label5.setSize(120, 15);
            this.add(this.label5);
            this.compressBox_ = new Checkbox("Compress output stream", Jedas.COMPRESS_OUTPUT);
            this.compressBox_.setLocation(40, 150);
            this.compressBox_.setSize(200, 20);
            this.add(this.compressBox_);
            ButtonListener btList = new ButtonListener();
            this.button0 = new Button(PreferencesDialog.APPLY);
            this.button0.setLocation(160, 180);
            this.button0.setSize(80, 30);
            this.button0.addActionListener(btList);
            this.add(this.button0);
            this.button1 = new Button(PreferencesDialog.CANCEL);
            this.button1.setLocation(250, 180);
            this.button1.setSize(80, 30);
            this.button1.addActionListener(btList);
            this.add(this.button1);
        }

        public Dimension getPreferredSize() {
            return new Dimension(340, 215);
        }
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        public void windowClosing(WindowEvent e) {
            PreferencesDialog.this.closeWindow();
        }
    }
}

