/*
 * Decompiled with CFR 0.152.
 */
package jedas.utils;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jedas.Jedas;
import jedas.io.Recorder;
import jedas.utils.MemoryFrame;
import jedas.utils.PreferencesDialog;
import jedas.utils.UserDialog;
import jedas.utils.XFigExportFrame;

public class SettingsPopup
extends PopupMenu
implements ActionListener,
ItemListener {
    static final String PREFS = "Preferences...";
    static final String F_NAME = "File name: ";
    static final String RECORD = "Recording mode";
    static final String AOF = "AOF...";
    static final String DEBUG = "Debug mode";
    static final String IO_DEBUG = "IO Debug mode";
    static final String XFIG_EXP = "Export to XFig...";
    static final String MEM_WIN = "Memory status";
    static final String JEDAS_VER = "Jedas version...";
    CheckboxMenuItem recordItem;
    CheckboxMenuItem debugItem;
    CheckboxMenuItem ioDebugItem;
    CheckboxMenuItem memFrameItem;
    MenuItem fileNameItem;
    MemoryFrame memFrame = null;

    public SettingsPopup() {
        super("Jedas");
        this.initMenuItems();
        this.addActionListener(this);
    }

    public void initItems() {
        this.fileNameItem.setLabel(F_NAME + Recorder.getFileName());
        this.recordItem.setState(Jedas.isRecording());
        this.debugItem.setState(Jedas.DEBUGMODE);
        this.ioDebugItem.setState(Jedas.IO_DEBUGMODE);
    }

    void initMenuItems() {
        this.add(PREFS);
        this.addSeparator();
        this.fileNameItem = new MenuItem(F_NAME + Recorder.getFileName());
        this.add(this.fileNameItem);
        this.recordItem = new CheckboxMenuItem(RECORD, false);
        this.recordItem.addItemListener(this);
        this.add(this.recordItem);
        if (Jedas.isAofMode()) {
            this.add(AOF);
        }
        this.addSeparator();
        this.debugItem = new CheckboxMenuItem(DEBUG, Jedas.DEBUGMODE);
        this.debugItem.addItemListener(this);
        this.add(this.debugItem);
        this.ioDebugItem = new CheckboxMenuItem(IO_DEBUG, Jedas.IO_DEBUGMODE);
        this.ioDebugItem.addItemListener(this);
        this.add(this.ioDebugItem);
        this.addSeparator();
        this.memFrameItem = new CheckboxMenuItem(MEM_WIN, false);
        this.memFrameItem.addItemListener(this);
        this.add(this.memFrameItem);
        this.addSeparator();
        this.add(XFIG_EXP);
        this.addSeparator();
        this.add(JEDAS_VER);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(PREFS)) {
            try {
                new PreferencesDialog();
            }
            catch (Exception ex) {
                System.err.println("Jedas::Prefence dialog already active...");
            }
        } else if (cmd.startsWith(F_NAME)) {
            Recorder.openFileNameDialog();
        } else if (cmd.equals(JEDAS_VER)) {
            String[] txt = new String[]{"Used JEDAS version: v201", "", "(c) 2000 Department of Computer Science", "University of Freiburg, Germany", "", "Rainer Mueller & Martin Danielsson", "rmueller@informatik.uni-freiburg.de", "martin@danielsson.de"};
            String[] bts = new String[]{"OK"};
            new UserDialog(txt, bts, null);
        } else if (cmd.equals(XFIG_EXP)) {
            if (Jedas.DEBUGMODE) {
                System.err.println("XFig Export...");
            }
            new XFigExportFrame();
        } else if (cmd.equals(AOF) && Jedas.DEBUGMODE) {
            System.err.println(AOF);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        CheckboxMenuItem select = (CheckboxMenuItem)e.getSource();
        if (select.equals(this.recordItem)) {
            boolean newState = this.recordItem.getState();
            boolean success = Jedas.setRecording(newState);
            if (!success) {
                this.recordItem.setState(!newState);
            }
        } else if (select.equals(this.debugItem)) {
            Jedas.DEBUGMODE = this.debugItem.getState();
        } else if (select.equals(this.ioDebugItem)) {
            Jedas.IO_DEBUGMODE = this.ioDebugItem.getState();
        } else if (select.equals(this.memFrameItem)) {
            if (this.memFrameItem.getState()) {
                if (this.memFrame == null) {
                    this.memFrame = new MemoryFrame();
                }
            } else if (this.memFrame != null) {
                this.memFrame.dispose();
                this.memFrame = null;
            }
        }
    }

    private class FileNameDialog
    extends Frame {
        FileNamePanel panel;

        public FileNameDialog() {
            super("Animation file name");
            this.setLayout(new BorderLayout());
            this.panel = new FileNamePanel();
            ButtonListener btList = new ButtonListener();
            this.panel.button0.addActionListener(btList);
            this.panel.button1.addActionListener(btList);
            this.add((Component)this.panel, "Center");
            this.pack();
            this.setLocation(200, 150);
            this.setVisible(true);
        }

        public void closeWindow() {
            this.dispose();
        }

        private class ButtonListener
        implements ActionListener {
            private ButtonListener() {
            }

            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals("OK")) {
                    Recorder.setFileName(FileNameDialog.this.panel.edFileName.getText());
                    FileNameDialog.this.closeWindow();
                }
                if (cmd.equals("Cancel")) {
                    FileNameDialog.this.closeWindow();
                }
            }
        }

        class FileNamePanel
        extends Panel {
            Label label0;
            public TextField edFileName;
            public Button button0;
            public Button button1;

            public FileNamePanel() {
                this.setLayout(null);
                this.label0 = new Label("Enter file name:");
                this.label0.setLocation(10, 10);
                this.label0.setSize(110, 13);
                this.add(this.label0);
                this.edFileName = new TextField(Recorder.getFileName());
                this.edFileName.setLocation(10, 27);
                this.edFileName.setSize(255, 30);
                this.add(this.edFileName);
                this.button0 = new Button("OK");
                this.button0.setLocation(10, 62);
                this.button0.setSize(80, 30);
                this.add(this.button0);
                this.button1 = new Button("Cancel");
                this.button1.setLocation(184, 62);
                this.button1.setSize(80, 30);
                this.add(this.button1);
            }

            public Dimension getPreferredSize() {
                return new Dimension(276, 107);
            }
        }
    }
}

