/*
 * Decompiled with CFR 0.152.
 */
package jedas.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jedas.Jedas;
import jedas.utils.ImageLoader;
import jedas.utils.Toolbar;

public class ToolButton
extends Panel {
    private boolean hasfocus = false;
    private boolean selected = false;
    private boolean toggle = true;
    private Toolbar toolbar = null;
    private Image image = null;
    private Image disabledImage = null;
    private Dimension dim = null;
    private String caption = null;
    private int subTag = 0;
    private Color backColor = Jedas.DEFAULT_BGCOLOR;
    private Font font = new Font("SansSerif", 0, 12);

    public ToolButton(Toolbar toolbar, Dimension dim, int subTag, MouseAdapter l) {
        this.enableEvents(16L);
        this.addMouseListener(l);
        this.subTag = subTag;
        this.dim = dim;
        this.toolbar = toolbar;
        this.disabledImage = null;
        if (toolbar != null) {
            toolbar.addElement(this);
        }
    }

    public ToolButton(Toolbar toolbar, Dimension pos, Dimension dim, String imagePath, String caption, int subTag, boolean toggle, MouseAdapter l) {
        this(toolbar, dim, subTag, l);
        this.caption = caption;
        this.toggle = toggle;
        if (imagePath != null) {
            try {
                ImageLoader il = new ImageLoader();
                this.image = il.getImage(imagePath, Toolkit.getDefaultToolkit());
            }
            catch (Exception e) {
                // empty catch block
            }
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(this.image, 0);
            try {
                mt.waitForAll();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.image == null) {
                System.err.println("Image not found: " + imagePath);
            }
        }
        if (pos != null) {
            this.setBounds(pos.getSize().width, pos.getSize().height, this.getPreferredSize().width, this.getPreferredSize().height);
        }
    }

    public ToolButton(Toolbar toolbar, Color backColor, Dimension dim, MouseAdapter l) {
        this(toolbar, dim, backColor.getRGB(), l);
        this.backColor = backColor;
    }

    public void setDisabledImage(String imagePath) {
        if (imagePath != null) {
            ImageLoader il = new ImageLoader();
            this.disabledImage = il.getImage(imagePath, Toolkit.getDefaultToolkit());
            MediaTracker mt = new MediaTracker(this);
            mt.addImage(this.disabledImage, 0);
            try {
                mt.waitForAll();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.disabledImage == null) {
                System.err.println("Image not found: " + imagePath);
            }
        }
    }

    public void setEnabled(boolean b) {
        if (Jedas.DEBUGMODE) {
            System.out.println("ToolButton::setEnabled(" + b + ")");
        }
        if (this.disabledImage != null && this.image != null) {
            if (this.isEnabled() && !b || !this.isEnabled() && b) {
                Image tmp = this.disabledImage;
                this.disabledImage = this.image;
                this.image = tmp;
                this.repaint();
            }
            if (this.isEnabled() && !b) {
                this.hasfocus = false;
            }
        }
        super.setEnabled(b);
    }

    public int getTag() {
        if (this.toolbar == null) {
            return this.subTag;
        }
        return this.toolbar.getTag();
    }

    public int getSubTag() {
        return this.subTag;
    }

    public Dimension getPreferredSize() {
        if (this.dim != null) {
            return this.dim;
        }
        int x = 6;
        int y = 6;
        if (this.image != null) {
            x += this.image.getWidth(this);
            y += this.image.getHeight(this);
        }
        if (this.caption != null) {
            x += this.getFontMetrics(this.font).stringWidth(this.caption) + 10;
        }
        return new Dimension(x, y);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void select() {
        if (this.toggle) {
            this.selected = true;
        }
    }

    public void deselect() {
        this.selected = false;
        this.repaint();
    }

    private void drawButton(Graphics g, int x, int y) {
        if (this.image != null) {
            g.drawImage(this.image, x, y, this);
        }
        if (this.caption != null) {
            x = this.getFontMetrics(this.font).stringWidth(this.caption) + 10;
            g.setColor(Color.black);
            g.setFont(this.font);
            g.drawString(this.caption, this.getSize().width - x, y + this.getSize().height * 3 / 5);
        }
    }

    public void paint(Graphics g) {
        g.setColor(this.backColor);
        g.fillRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
        if (this.selected) {
            if (this.hasfocus && this.isEnabled()) {
                g.setColor(Color.darkGray);
            }
            g.draw3DRect(1, 1, this.getSize().width - 2, this.getSize().height - 2, false);
            this.drawButton(g, 4, 4);
        } else if (this.hasfocus && this.isEnabled()) {
            g.draw3DRect(1, 1, this.getSize().width - 2, this.getSize().height - 2, true);
            this.drawButton(g, 2, 2);
        } else {
            this.drawButton(g, 3, 3);
        }
    }

    protected void processMouseEvent(MouseEvent event) {
        switch (event.getID()) {
            case 501: {
                if (this.toolbar != null) {
                    this.toolbar.select(this);
                } else {
                    this.select();
                }
                this.hasfocus = false;
                break;
            }
            case 502: {
                break;
            }
            case 504: {
                this.hasfocus = true;
                break;
            }
            case 505: {
                this.hasfocus = false;
            }
        }
        this.repaint();
        super.processMouseEvent(event);
    }
}

