/*
 * Decompiled with CFR 0.152.
 */
package jedas.utils;

import java.awt.Button;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import jedas.CompPanel;
import jedas.Jedas;

public class XFigExportPanel
extends Panel {
    private static final String EXPORT = "Export";
    private static final String RESCAN = "Rescan CompPanels";
    private static final String CLOSE = "Close window";
    Label label0;
    Label label1;
    Button button0;
    Button button1;
    Button button2;
    List compList;
    Frame parentFrame = null;

    public XFigExportPanel() {
        this((Frame)null);
    }

    public XFigExportPanel(Frame parentFrame) {
        this.parentFrame = parentFrame;
        this.setLayout(null);
        this.label0 = new Label("XFig export");
        this.label0.setLocation(10, 10);
        this.label0.setSize(80, 15);
        this.add(this.label0);
        this.label1 = new Label("Choose CompPanel instance:");
        this.label1.setLocation(10, 29);
        this.label1.setSize(200, 15);
        this.add(this.label1);
        this.compList = new List(5, false);
        this.compList.setLocation(10, 50);
        this.compList.setSize(250, 100);
        this.getCompPanels(this.compList);
        this.add(this.compList);
        ButtonListener action = new ButtonListener();
        this.button0 = new Button(EXPORT);
        this.button0.setLocation(270, 50);
        this.button0.setSize(140, 30);
        this.button0.addActionListener(action);
        this.add(this.button0);
        this.button1 = new Button(RESCAN);
        this.button1.setLocation(270, 85);
        this.button1.setSize(140, 30);
        this.button1.addActionListener(action);
        this.add(this.button1);
        this.button2 = new Button(CLOSE);
        this.button2.setLocation(270, 120);
        this.button2.setSize(140, 30);
        this.button2.addActionListener(action);
        this.add(this.button2);
        if (parentFrame == null) {
            this.button2.setEnabled(false);
        }
    }

    private void getCompPanels(List list) {
        list.removeAll();
        Hashtable recs = Jedas.getRecordableTable();
        Enumeration enumeration = recs.elements();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!(o instanceof CompPanel)) continue;
            list.add(((CompPanel)o).getName());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(416, 159);
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            block14: {
                String cmd = e.getActionCommand();
                if (cmd.equals(XFigExportPanel.EXPORT)) {
                    String selCP = XFigExportPanel.this.compList.getSelectedItem();
                    if (selCP != null) {
                        FileDialog exp = new FileDialog(XFigExportPanel.this.parentFrame, "XFig Export", 1);
                        exp.show();
                        if (exp.getFile() != null) {
                            String fileName = exp.getDirectory() + exp.getFile();
                            if (Jedas.DEBUGMODE) {
                                System.err.println("XFigExportPanel::Exporting to \"" + fileName + "\"");
                            }
                            try {
                                FileWriter fw = new FileWriter(fileName);
                                PrintWriter out = new PrintWriter(fw);
                                CompPanel cp = null;
                                Enumeration enumeration = Jedas.getRecordableTable().elements();
                                while (enumeration.hasMoreElements() && cp == null) {
                                    Object o = enumeration.nextElement();
                                    if (!(o instanceof CompPanel) || !((CompPanel)o).getName().equals(selCP)) continue;
                                    cp = (CompPanel)o;
                                }
                                if (cp != null) {
                                    System.err.println("XFig scale: X=" + Jedas.XFIG_X_SCALE + ", Y=" + Jedas.XFIG_Y_SCALE);
                                    out.println("#FIG 3.2");
                                    out.println("Landscape");
                                    out.println("Center");
                                    out.println("Metric");
                                    out.println("A4");
                                    out.println("100.0");
                                    out.println("Single");
                                    out.println("-2");
                                    out.println("1200 2");
                                    Jedas.XFIG_DEPTH = 999;
                                    cp.writeXFigObject(out);
                                    out.close();
                                    break block14;
                                }
                                System.err.println("*** Could not refind \"" + selCP + "\"!");
                            }
                            catch (Exception ex) {
                                System.err.println("*** IOException has occurred!");
                                System.err.println(ex);
                                ex.printStackTrace();
                            }
                        } else if (Jedas.DEBUGMODE) {
                            System.err.println("XFigExportPanel::Export aborted.");
                        }
                    }
                } else if (cmd.equals(XFigExportPanel.RESCAN)) {
                    XFigExportPanel.this.getCompPanels(XFigExportPanel.this.compList);
                } else if (cmd.equals(XFigExportPanel.CLOSE)) {
                    XFigExportPanel.this.parentFrame.dispose();
                }
            }
        }
    }
}

