/*
 * Decompiled with CFR 0.152.
 */
package mlb.extapp;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.util.Vector;
import jedas.utils.Misc;
import mlb.xml.XmlParser;

public class ApplicationManager
extends Frame {
    private static final String MENU_FILE = "File";
    private static final String MENU_LOAD_LIST = "Load...";
    private static final String MENU_SAVE_LIST = "Save";
    private static final String MENU_SAVE_LIST_AS = "Save as...";
    private static final String MENU_CONNECTED = "Connected to Mlb/AofWB";
    private static final String MENU_AUTOCONNECT = "Autoconnect";
    private static final String MENU_QUIT = "Quit";
    private static final String MENU_ANIMS = "Animations";
    private static final String MENU_ANIMS_SCAN = "Scan directory";
    private static final String MENU_ANIMS_INSERT = "Insert animation manually...";
    private static final String MENU_ANIMS_REMOVE = "Remove animation";
    private static final String MENU_ANIMS_START = "Start Animation";
    private static final String MENU_SCRIPTS = "Scripts";
    private static final String MENU_SCRIPTS_INSERT = "Insert external application...";
    private static final String MENU_SCRIPTS_REMOVE = "Remove application";
    private static final String MENU_SCRIPTS_START = "Start application";
    private static final String MENU_VIEW = "View";
    private static final String MENU_VIEW_JEDAS = "JEDAS Animations";
    private static final String MENU_VIEW_SCRIPTS = "General scripts";
    private static final String POPUP_REMOVE = "Remove entry";
    private static final char AOF_RETRIEVE_RECORD_TIME = '0';
    private static final char AOF_RETRIEVE_NAME = '1';
    private static final char AOF_RETRIEVE_PATH = '2';
    private static final char AOF_NOTIFY_JEDAS = '3';
    private static final char AOF_NOTIFY_EXTAPP = '4';
    private ScrollPane jedasScrollPane_ = null;
    private ScrollPane scriptScrollPane_ = null;
    private Panel animationPanel_ = null;
    private Panel scriptPanel_ = null;
    private TextArea animInformation_ = null;
    private TextField parameterField_ = null;
    private Vector animationVector_ = null;
    private Panel notePad_ = null;
    private CardLayout notePadLayout_ = null;
    private MenuItem insertScriptMenuItem_ = null;
    private CheckboxMenuItem cbmiJedasAnims_ = null;
    private CheckboxMenuItem cbmiScripts_ = null;
    private CheckboxMenuItem cbmiConnected_ = null;
    private CheckboxMenuItem cbmiAutoconnect_ = null;
    private AofClient aofClient_ = null;
    private boolean hasNotifiedAof_ = false;
    private Label statusLabel_ = null;
    private Menu animsMenu_ = null;
    private Menu scriptsMenu_ = null;
    private AnimInformationPanel selectedAnimPanel_ = null;
    private MouseListener animPanelListener_ = null;
    private ScriptInformationPanel selectedScriptPanel_ = null;
    private MouseListener scriptPanelListener_ = null;
    private String fileName_ = null;
    private String pathName_ = null;

    public static void main(String[] args) {
        if (args.length > 0) {
            new ApplicationManager(args[0]);
        } else {
            new ApplicationManager();
        }
    }

    public ApplicationManager() {
        super("[untitled] - Application manager");
        this.fileName_ = null;
        this.pathName_ = null;
        this.initGUI();
    }

    public ApplicationManager(String fileName) {
        super("[" + fileName + "] - Application manager");
        File settingsFile = new File(fileName);
        this.fileName_ = settingsFile.getName();
        this.pathName_ = settingsFile.getAbsolutePath();
        this.initGUI();
        this.readSettingsFile();
    }

    private void initGUI() {
        MenuItemListener mil = new MenuItemListener();
        CheckboxMenuItemListener cbmil = new CheckboxMenuItemListener();
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = new Menu(MENU_FILE);
        menuBar.add(fileMenu);
        MenuItem menuItem = new MenuItem(MENU_LOAD_LIST);
        menuItem.addActionListener(mil);
        fileMenu.add(menuItem);
        menuItem = new MenuItem(MENU_SAVE_LIST);
        menuItem.addActionListener(mil);
        fileMenu.add(menuItem);
        menuItem = new MenuItem(MENU_SAVE_LIST_AS);
        menuItem.addActionListener(mil);
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        this.cbmiConnected_ = new CheckboxMenuItem(MENU_CONNECTED);
        this.cbmiConnected_.addItemListener(cbmil);
        fileMenu.add(this.cbmiConnected_);
        this.cbmiAutoconnect_ = new CheckboxMenuItem(MENU_AUTOCONNECT, true);
        this.cbmiAutoconnect_.addItemListener(cbmil);
        fileMenu.add(this.cbmiAutoconnect_);
        fileMenu.addSeparator();
        menuItem = new MenuItem(MENU_QUIT);
        menuItem.addActionListener(mil);
        fileMenu.add(menuItem);
        this.animsMenu_ = new Menu(MENU_ANIMS);
        menuItem = new MenuItem(MENU_ANIMS_SCAN);
        menuItem.addActionListener(mil);
        this.animsMenu_.add(menuItem);
        menuItem = new MenuItem(MENU_ANIMS_INSERT);
        menuItem.addActionListener(mil);
        this.animsMenu_.add(menuItem);
        menuItem = new MenuItem(MENU_ANIMS_REMOVE);
        menuItem.addActionListener(mil);
        this.animsMenu_.add(menuItem);
        this.animsMenu_.addSeparator();
        menuItem = new MenuItem(MENU_ANIMS_START);
        menuItem.addActionListener(mil);
        this.animsMenu_.add(menuItem);
        menuBar.add(this.animsMenu_);
        this.scriptsMenu_ = new Menu(MENU_SCRIPTS);
        this.insertScriptMenuItem_ = new MenuItem(MENU_SCRIPTS_INSERT);
        this.insertScriptMenuItem_.addActionListener(mil);
        this.scriptsMenu_.add(this.insertScriptMenuItem_);
        menuItem = new MenuItem(MENU_SCRIPTS_REMOVE);
        menuItem.addActionListener(mil);
        this.scriptsMenu_.add(menuItem);
        this.scriptsMenu_.addSeparator();
        menuItem = new MenuItem(MENU_SCRIPTS_START);
        menuItem.addActionListener(mil);
        this.scriptsMenu_.add(menuItem);
        this.scriptsMenu_.setEnabled(false);
        menuBar.add(this.scriptsMenu_);
        Menu viewMenu = new Menu(MENU_VIEW);
        menuBar.add(viewMenu);
        this.cbmiJedasAnims_ = new CheckboxMenuItem(MENU_VIEW_JEDAS, true);
        this.cbmiJedasAnims_.addItemListener(cbmil);
        viewMenu.add(this.cbmiJedasAnims_);
        this.cbmiScripts_ = new CheckboxMenuItem(MENU_VIEW_SCRIPTS, false);
        this.cbmiScripts_.addItemListener(cbmil);
        viewMenu.add(this.cbmiScripts_);
        this.setMenuBar(menuBar);
        this.notePad_ = new Panel();
        this.notePadLayout_ = new CardLayout();
        this.notePad_.setLayout(this.notePadLayout_);
        Panel jedasAnimPanel = new Panel();
        jedasAnimPanel.setLayout(new BorderLayout());
        this.jedasScrollPane_ = new ScrollPane(1){

            public Dimension getPreferredSize() {
                return new Dimension(180, 300);
            }
        };
        this.animationPanel_ = new Panel();
        this.animationPanel_.setLayout(new GridLayout(0, 1));
        this.jedasScrollPane_.add(this.animationPanel_);
        jedasAnimPanel.add((Component)this.jedasScrollPane_, "Center");
        Panel infoPanel = new Panel();
        infoPanel.setLayout(new BorderLayout());
        this.animInformation_ = new TextArea("Select an animation,\nenter parameters above.", 5, 30, 1);
        infoPanel.add((Component)this.animInformation_, "Center");
        this.parameterField_ = new TextField("", 30);
        infoPanel.add((Component)this.parameterField_, "North");
        jedasAnimPanel.add((Component)infoPanel, "South");
        this.scriptScrollPane_ = new ScrollPane(1){

            public Dimension getPreferredSize() {
                return new Dimension(180, 300);
            }
        };
        this.scriptPanel_ = new Panel();
        this.scriptPanel_.setLayout(new GridLayout(0, 1));
        this.scriptScrollPane_.add(this.scriptPanel_);
        this.notePad_.add((Component)jedasAnimPanel, "jedas");
        this.notePad_.add((Component)this.scriptScrollPane_, "scripts");
        this.add((Component)this.notePad_, "Center");
        this.statusLabel_ = new Label("Welcome!");
        this.add((Component)this.statusLabel_, "South");
        this.addWindowListener(new WindowListener());
        this.animPanelListener_ = new AnimPanelListener();
        this.scriptPanelListener_ = new ScriptPanelListener();
        this.pack();
        this.setVisible(true);
    }

    private void loadSettingsFromFile() {
        FileDialog openFileDialog = new FileDialog((Frame)this, "Select settings file to load", 0);
        AppsFilenameFilter appsFilenameFilter = new AppsFilenameFilter();
        openFileDialog.setFilenameFilter(appsFilenameFilter);
        openFileDialog.show();
        String fileName = openFileDialog.getFile();
        if (fileName != null) {
            this.fileName_ = fileName;
            this.pathName_ = openFileDialog.getDirectory() + fileName;
            this.readSettingsFile();
        } else {
            this.setStatusMessage("Loading cancelled.");
        }
    }

    private void readSettingsFile() {
        File settingsFile = new File(this.pathName_);
        if (settingsFile.exists()) {
            this.selectedAnimPanel_ = null;
            this.selectedScriptPanel_ = null;
            this.animationPanel_.removeAll();
            this.scriptPanel_.removeAll();
            try {
                XmlParser parser = new XmlParser(this.pathName_);
                String name = null;
                String params = null;
                int tokenType = 0;
                while (tokenType != -1) {
                    tokenType = parser.getNextTag();
                    switch (tokenType) {
                        case 2: {
                            String token = parser.getToken();
                            if (token.equals("className") || token.equals("path")) {
                                name = parser.getPropertyOfToken();
                                break;
                            }
                            if (!token.equals("params")) break;
                            params = parser.getPropertyOfToken();
                            break;
                        }
                        case 1: {
                            String token = parser.getToken();
                            if (token.equals("JEDAS")) {
                                AnimInformationPanel aip = new AnimInformationPanel(name, this.animInformation_);
                                aip.setParameters(params);
                                try {
                                    Class<?> animClass = Class.forName(name);
                                    String[] infos = ApplicationManager.retrieveClassInformation(animClass);
                                    aip.setInformation(infos);
                                }
                                catch (ClassNotFoundException e) {
                                    aip.setInformation(new String[]{"<class not found!>"});
                                }
                                this.animationPanel_.add(aip);
                                break;
                            }
                            if (!token.equals("SCRIPT")) break;
                            File tmpFile = new File(name);
                            ScriptInformationPanel sip = new ScriptInformationPanel(tmpFile.getName(), tmpFile.getAbsolutePath());
                            this.scriptPanel_.add(sip);
                        }
                    }
                }
                this.animationPanel_.doLayout();
                this.jedasScrollPane_.doLayout();
                this.scriptPanel_.doLayout();
                this.scriptScrollPane_.doLayout();
                this.setStatusMessage("Loaded '" + this.fileName_ + "'.");
                this.setTitle(this.fileName_);
            }
            catch (IOException e) {
                this.setStatusMessage(e.toString());
                e.printStackTrace();
            }
        } else {
            this.setTitle("*" + this.fileName_);
        }
    }

    private void saveSettingsToFile() {
        if (this.fileName_ != null) {
            this.performSaveSettingsToFile();
        } else {
            this.saveSettingsAsToFile();
        }
    }

    private void saveSettingsAsToFile() {
        FileDialog saveFileDialog = new FileDialog((Frame)this, "Save settings file as", 1);
        AppsFilenameFilter appsFilenameFilter = new AppsFilenameFilter();
        saveFileDialog.setFilenameFilter(appsFilenameFilter);
        saveFileDialog.show();
        String fileName = saveFileDialog.getFile();
        if (fileName != null) {
            this.fileName_ = fileName;
            this.pathName_ = saveFileDialog.getDirectory() + fileName;
            this.performSaveSettingsToFile();
        } else {
            this.setStatusMessage("No file saved.");
        }
    }

    private void performSaveSettingsToFile() {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.pathName_));
            out.println("<APPSMANAGER>");
            Component[] animPanels = this.animationPanel_.getComponents();
            Component[] scriptPanels = this.scriptPanel_.getComponents();
            out.println("  <ANIMATIONS>");
            int i = 0;
            while (i < animPanels.length) {
                if (animPanels[i] instanceof AnimInformationPanel) {
                    AnimInformationPanel aip = (AnimInformationPanel)animPanels[i];
                    out.println("    <JEDAS className=\"" + this.convertBackslashes(aip.getName()) + "\"" + " params=\"" + this.convertParameters(aip.getParameters()) + "\"></JEDAS>");
                }
                ++i;
            }
            out.println("  </ANIMATIONS>");
            out.println("  <SCRIPTS>");
            int i2 = 0;
            while (i2 < scriptPanels.length) {
                if (scriptPanels[i2] instanceof ScriptInformationPanel) {
                    ScriptInformationPanel sip = (ScriptInformationPanel)scriptPanels[i2];
                    out.println("    <SCRIPT path=\"" + this.convertBackslashes(sip.getFullName()) + "\"></SCRIPT>");
                }
                ++i2;
            }
            out.println("  </SCRIPTS>");
            out.println("</APPSMANAGER>");
            out.flush();
            out.close();
            this.setStatusMessage("Saved file as '" + this.fileName_ + "'.");
            this.setTitle(this.fileName_);
        }
        catch (IOException e) {
            this.setStatusMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    private String convertParameters(String string) {
        char[] chars = string.toCharArray();
        String tmp = "";
        int i = 0;
        while (i < chars.length) {
            tmp = chars[i] == '\"' ? tmp + "\\\"" : (chars[i] == '\'' ? tmp + "\\'" : tmp + chars[i]);
            ++i;
        }
        return tmp;
    }

    private String convertBackslashes(String string) {
        char[] chars = string.toCharArray();
        String tmp = "";
        int i = 0;
        while (i < chars.length) {
            tmp = chars[i] == '\\' ? tmp + "\\\\" : tmp + chars[i];
            ++i;
        }
        return tmp;
    }

    public void setTitle(String title) {
        super.setTitle("[" + title + "] - Application manager");
    }

    private void scanDirectoryForAnimations() {
        block5: {
            try {
                int classCount = 0;
                File currentDir = new File(".");
                if (currentDir.isDirectory()) {
                    String[] classFiles = currentDir.list(new ClassFileFilter());
                    Misc.sortStrings(classFiles);
                    int i = 0;
                    while (i < classFiles.length) {
                        String[] infos;
                        String className = classFiles[i].substring(0, classFiles[i].length() - 6);
                        Class<?> class_ = Class.forName(className);
                        if (ApplicationManager.hasClassMainMethod(class_) && (infos = ApplicationManager.retrieveClassInformation(class_)) != null) {
                            AnimInformationPanel aip = this.addAnimationToPanel(className);
                            aip.setInformation(infos);
                            ++classCount;
                        }
                        ++i;
                    }
                    if (classCount != 0) break block5;
                    this.setStatusMessage("No animation classes found.");
                    break block5;
                }
                this.setStatusMessage("'.' should be a directory!!?");
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
            }
        }
    }

    private static boolean hasClassMainMethod(Class class_) {
        try {
            String[] temp = new String[]{"temp"};
            Class<?> stringArray = temp.getClass();
            Method main = class_.getDeclaredMethod("main", stringArray);
            int modifiers = main.getModifiers();
            return Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static String[] retrieveClassInformation(Class class_) {
        try {
            Class[] signature = new Class[]{};
            Method getAnimationInformation = class_.getDeclaredMethod("getAnimationInformation", signature);
            int modifiers = getAnimationInformation.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                Object strings = getAnimationInformation.invoke(null, new Object[0]);
                return (String[])strings;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return new String[]{"Security exception thrown."};
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return new String[]{"IllegalAccessException"};
        }
        catch (InvocationTargetException e) {
            return new String[]{"IncovationTargetException"};
        }
    }

    private AnimInformationPanel addAnimationToPanel(String className) {
        AnimInformationPanel aip = new AnimInformationPanel(className, this.animInformation_);
        this.animationPanel_.add(aip);
        this.animationPanel_.doLayout();
        this.jedasScrollPane_.doLayout();
        return aip;
    }

    private void insertAnimation() {
        block4: {
            EnterAnimNameDialog eand = new EnterAnimNameDialog(this);
            eand.show();
            String className = eand.getClassName();
            if (className == null) break block4;
            try {
                Class<?> newClass = Class.forName(className);
                if (!ApplicationManager.hasClassMainMethod(newClass)) break block4;
                String[] infos = ApplicationManager.retrieveClassInformation(newClass);
                if (infos != null) {
                    AnimInformationPanel aip = this.addAnimationToPanel(className);
                    aip.setInformation(infos);
                    break block4;
                }
                throw new NotJedasAnimationException("The given class name is not a JEDAS animation.");
            }
            catch (ClassNotFoundException e) {
                System.err.println(e);
                e.printStackTrace();
            }
            catch (NotJedasAnimationException e) {
                System.err.println(e);
                e.printStackTrace();
            }
        }
    }

    private void removeSelectedAnimation() {
        if (this.selectedAnimPanel_ != null) {
            this.selectedAnimPanel_.removeFromList();
            this.selectedAnimPanel_ = null;
            this.setStatusMessage("Animation removed.");
        } else {
            this.setStatusMessage("No animation selected: cannot remove.");
        }
    }

    private synchronized void startSelectedAnimation() {
        if (this.selectedAnimPanel_ != null) {
            this.selectedAnimPanel_.setParameters(this.parameterField_.getText());
            this.selectedAnimPanel_.startProcess();
        } else {
            this.setStatusMessage("No animation selected: cannot start.");
        }
    }

    private synchronized void selectAnimPanel(AnimInformationPanel source) {
        if (source == this.selectedAnimPanel_) {
            if (source.isDoubleClick()) {
                this.startSelectedAnimation();
            }
            source.setSelected(true);
            return;
        }
        if (this.selectedAnimPanel_ != null) {
            this.selectedAnimPanel_.setParameters(this.parameterField_.getText());
            this.selectedAnimPanel_.setSelected(false);
        }
        source.setSelected(true);
        this.parameterField_.setText(source.getParameters());
        this.selectedAnimPanel_ = source;
    }

    private void setStatusMessage(String statusMessage) {
        if (statusMessage != null) {
            this.statusLabel_.setText(statusMessage);
        }
    }

    private void tryConnectToAof() {
        if (this.aofClient_ != null) {
            this.setStatusMessage("Already connected!");
            return;
        }
        try {
            this.setStatusMessage("Connecting to AOF...");
            this.aofClient_ = new AofClient();
            this.aofClient_.out.writeByte(49);
            this.aofClient_.out.flush();
            this.aofClient_.plainName = this.aofClient_.in.readLine();
            this.aofClient_.out.writeByte(50);
            this.aofClient_.out.flush();
            this.aofClient_.aofDocumentPath = this.aofClient_.in.readLine();
            this.setStatusMessage("Connection established.");
            this.cbmiConnected_.setState(true);
            this.writeAppobjFile();
            this.insertScriptMenuItem_.setEnabled(false);
        }
        catch (IOException e) {
            this.setStatusMessage("Connection failed.");
            this.aofClient_ = null;
            this.cbmiConnected_.setState(false);
        }
    }

    private void disconnectFromAof() {
        if (this.aofClient_ == null) {
            this.setStatusMessage("Cannot disconnect: Not connected.");
            return;
        }
        try {
            this.aofClient_.socket.close();
            this.setStatusMessage("Disconnected.");
        }
        catch (IOException e) {
            this.setStatusMessage(e.toString());
        }
        this.aofClient_ = null;
        this.insertScriptMenuItem_.setEnabled(true);
        this.hasNotifiedAof_ = false;
    }

    private boolean isConnectedToAof() {
        return this.aofClient_ != null;
    }

    private boolean shouldAutoconnect() {
        return this.cbmiAutoconnect_.getState();
    }

    private long getAofRecordTime() {
        if (!this.isConnectedToAof()) {
            return -1L;
        }
        try {
            this.aofClient_.out.writeByte(48);
            this.aofClient_.out.flush();
            String back = this.aofClient_.in.readLine();
            long tmpTime = Long.parseLong(back);
            return tmpTime;
        }
        catch (IOException e) {
            this.disconnectFromAof();
            return -1L;
        }
    }

    private void writeAppobjFile() {
        if (this.scriptPanel_.getComponentCount() == 0) {
            return;
        }
        try {
            File appevqFile = new File(this.aofClient_.aofDocumentPath + this.aofClient_.plainName + ".appevq");
            if (appevqFile.exists()) {
                appevqFile.delete();
            }
            PrintWriter out = new PrintWriter(new FileWriter(this.aofClient_.aofDocumentPath + this.aofClient_.plainName + ".appobj"));
            out.println("<APPS>");
            System.out.println("<APPS>");
            out.flush();
            Component[] scriptPanel = this.scriptPanel_.getComponents();
            int scriptCount = 0;
            int i = 0;
            while (i < scriptPanel.length) {
                if (scriptPanel[i] instanceof ScriptInformationPanel) {
                    ScriptInformationPanel sip = (ScriptInformationPanel)scriptPanel[i];
                    sip.setNumber(scriptCount++);
                    out.println("<APP filename=" + sip.getName() + "></APP>");
                    System.out.println("<APP filename=" + sip.getName() + "></APP>");
                    out.flush();
                }
                ++i;
            }
            out.println("</APPS>");
            System.out.println("</APPS>");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            this.setStatusMessage(e.toString());
            e.printStackTrace();
        }
    }

    private synchronized void appendToAppevqFile(int scriptNumber, long startTime, long endTime) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.aofClient_.aofDocumentPath + this.aofClient_.plainName + ".appevq"));
            out.println(startTime + " " + scriptNumber);
            out.flush();
            out.println(endTime);
            out.flush();
            out.close();
            this.aofClient_.out.writeByte(52);
            this.aofClient_.out.flush();
        }
        catch (IOException e) {
            this.setStatusMessage(e.toString());
            e.printStackTrace();
        }
    }

    private void insertScript() {
        FileDialog openFileDialog = new FileDialog((Frame)this, "Select external application", 0);
        openFileDialog.show();
        String fileName = openFileDialog.getFile();
        if (fileName != null) {
            String directory = openFileDialog.getDirectory();
            ScriptInformationPanel scriptPanel = new ScriptInformationPanel(fileName, directory + fileName);
            this.scriptPanel_.add(scriptPanel);
            this.scriptPanel_.doLayout();
            this.scriptScrollPane_.doLayout();
            this.setStatusMessage("Added script '" + fileName + "'.");
        }
    }

    private void removeSelectedScript() {
        if (this.selectedScriptPanel_ != null) {
            this.selectedScriptPanel_.removeFromList();
            this.selectedScriptPanel_ = null;
            this.setStatusMessage("Script removed.");
        } else {
            this.setStatusMessage("No script selected: cannot remove.");
        }
    }

    private synchronized void startSelectedScript() {
        if (this.selectedScriptPanel_ != null) {
            if (this.shouldAutoconnect() && !this.isConnectedToAof()) {
                this.tryConnectToAof();
            }
            this.selectedScriptPanel_.startProcess();
        } else {
            this.setStatusMessage("No script selected: cannot start.");
        }
    }

    private synchronized void selectScriptPanel(ScriptInformationPanel source) {
        if (source == this.selectedScriptPanel_) {
            if (source.isDoubleClick()) {
                this.startSelectedScript();
            }
            source.setSelected(true);
            return;
        }
        if (this.selectedScriptPanel_ != null) {
            this.selectedScriptPanel_.setSelected(false);
        }
        source.setSelected(true);
        this.selectedScriptPanel_ = source;
    }

    class AofClient {
        public Socket socket = new Socket("localhost", 6002);
        public long aofRecordTime = -1L;
        public BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        public DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
        public String plainName = "<none>";
        public String aofDocumentPath = "";
    }

    private abstract class InformationPanel
    extends Panel {
        private boolean isSelected_ = false;
        private String name_ = "";
        private int processCount_ = 0;
        private long clickTime_ = 0L;
        private int number_ = -1;
        private Vector processVector_ = new Vector();

        public InformationPanel(String name) {
            this.name_ = name;
        }

        public void setSelected(boolean selected) {
            this.isSelected_ = selected;
            this.repaint();
            this.clickTime_ = System.currentTimeMillis();
        }

        public boolean isSelected() {
            return this.isSelected_;
        }

        public boolean isDoubleClick() {
            return System.currentTimeMillis() - this.clickTime_ < 500L;
        }

        public String getName() {
            return this.name_;
        }

        public Dimension getPreferredSize() {
            return new Dimension(150, 30);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void incrementProcessCount(Process process) {
            ++this.processCount_;
            this.processVector_.addElement(process);
            this.repaint();
        }

        public void decrementProcessCount(Process process) {
            --this.processCount_;
            this.processVector_.removeElement(process);
            this.repaint();
        }

        public int getProcessCount() {
            return this.processCount_;
        }

        public Vector getProcesses() {
            return this.processVector_;
        }

        protected abstract String[] getCommand();

        public void startProcess() {
            Runtime runtime = Runtime.getRuntime();
            String[] command = this.getCommand();
            System.out.print("--->");
            int i = 0;
            while (i < command.length) {
                System.out.print(" " + command[i]);
                ++i;
            }
            System.out.println();
            if (command != null) {
                try {
                    Process process = runtime.exec(command);
                    ProcessWaiter pw = new ProcessWaiter(process, this);
                    pw.start();
                    ApplicationManager.this.setStatusMessage("Launched Process '" + this.getName() + "'");
                }
                catch (IOException e) {
                    ApplicationManager.this.setStatusMessage(e.toString());
                    e.printStackTrace();
                }
            } else {
                ApplicationManager.this.setStatusMessage("Error: Cannot launch '" + this.getName() + "'!");
            }
        }

        public void removeFromList() {
            Container parent = this.getParent();
            parent.remove(this);
            parent.doLayout();
        }

        public void setNumber(int number) {
            this.number_ = number;
        }

        public int getNumber() {
            return this.number_;
        }

        public boolean shouldBeRecorded() {
            return false;
        }

        public void paint(Graphics g) {
            if (!this.isSelected()) {
                if (this.processCount_ == 0) {
                    g.setColor(Color.lightGray);
                } else {
                    g.setColor(Color.red);
                }
                g.fillRect(1, 1, this.getSize().width, this.getSize().height);
                g.setColor(Color.white);
                g.draw3DRect(1, 1, this.getSize().width - 2, this.getSize().height - 2, true);
                g.setColor(Color.black);
                g.drawString(this.name_, 9, 19);
            } else {
                if (this.processCount_ == 0) {
                    g.setColor(Color.darkGray);
                } else {
                    g.setColor(Color.orange);
                }
                g.fillRect(1, 1, this.getSize().width, this.getSize().height);
                g.setColor(Color.white);
                g.draw3DRect(1, 1, this.getSize().width - 2, this.getSize().height - 2, false);
                g.setColor(Color.white);
                g.drawString(this.name_, 11, 21);
            }
        }
    }

    private class ScriptPanelListener
    extends MouseAdapter {
        private ScriptPanelListener() {
        }

        public void mousePressed(MouseEvent e) {
            ScriptInformationPanel source = (ScriptInformationPanel)e.getSource();
            ApplicationManager.this.selectScriptPanel(source);
            if (e.isPopupTrigger()) {
                ProcessPopup popup = new ProcessPopup(source.getProcesses(), source);
                source.add(popup);
                popup.show(source, e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
            ScriptInformationPanel source = (ScriptInformationPanel)e.getSource();
            if (e.isPopupTrigger()) {
                ProcessPopup popup = new ProcessPopup(source.getProcesses(), source);
                source.add(popup);
                popup.show(source, e.getX(), e.getY());
            }
        }
    }

    private class ScriptInformationPanel
    extends InformationPanel {
        private String fullName_ = "";
        private int scriptNumber_ = -1;

        public ScriptInformationPanel(String scriptName, String fullName) {
            super(scriptName);
            this.addMouseListener(ApplicationManager.this.scriptPanelListener_);
            this.fullName_ = fullName;
        }

        public void setSelected(boolean selected) {
            if (selected) {
                ApplicationManager.this.setStatusMessage("(" + this.fullName_ + ")");
            }
            super.setSelected(selected);
        }

        public String getFullName() {
            return this.fullName_;
        }

        protected String[] getCommand() {
            return new String[]{this.fullName_};
        }

        public boolean shouldBeRecorded() {
            return true;
        }
    }

    private class EnterAnimNameDialog
    extends Dialog {
        private final String BUTTON_OK = "OK";
        private final String BUTTON_CANCEL = "Cancel";
        private TextField classTextField_;
        private String enteredClassName_ = null;
        private Label statusLabel_ = null;

        public EnterAnimNameDialog(Frame frame) {
            super(frame, "Enter Animation class name", true);
            this.setLayout(new GridLayout(3, 1));
            this.statusLabel_ = new Label("Enter the class name of the JEDAS animation:");
            this.add(this.statusLabel_);
            this.classTextField_ = new TextField("", 50);
            this.add(this.classTextField_);
            Panel buttons = new Panel();
            ButtonListener bl = new ButtonListener();
            Button b = new Button("OK");
            buttons.add(b);
            b.addActionListener(bl);
            b = new Button("Cancel");
            buttons.add(b);
            b.addActionListener(bl);
            this.add(buttons);
            this.pack();
            Point location = frame.getLocation();
            this.setLocation(location.x + 20, location.y + 20);
        }

        private void performOK() {
            try {
                this.enteredClassName_ = this.classTextField_.getText();
                Class<?> enteredClass = Class.forName(this.enteredClassName_);
                this.setVisible(false);
            }
            catch (ClassNotFoundException e) {
                this.enteredClassName_ = null;
                this.statusLabel_.setText("Class not found in CLASSPATH!");
            }
        }

        private void performCancel() {
            this.enteredClassName_ = null;
            this.setVisible(false);
        }

        public String getClassName() {
            return this.enteredClassName_;
        }

        private class ButtonListener
        implements ActionListener {
            private ButtonListener() {
            }

            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (cmd.equals("OK")) {
                    EnterAnimNameDialog.this.performOK();
                } else {
                    EnterAnimNameDialog.this.performCancel();
                }
            }
        }
    }

    private class ProcessPopup
    extends PopupMenu {
        private Vector processes_ = null;
        private InformationPanel source_ = null;

        public ProcessPopup(Vector processes, InformationPanel source) {
            this.processes_ = processes;
            this.source_ = source;
            PopupTrigger popupTrigger = new PopupTrigger();
            MenuItem mi = new MenuItem(ApplicationManager.POPUP_REMOVE);
            mi.addActionListener(popupTrigger);
            this.add(mi);
            if (this.processes_.size() > 0) {
                mi.setEnabled(false);
            }
            this.addSeparator();
            int i = 0;
            while (i < this.processes_.size()) {
                mi = new MenuItem("Kill process #" + i);
                mi.addActionListener(popupTrigger);
                this.add(mi);
                ++i;
            }
        }

        private void killProcess(String processString) {
            int processNumber = Integer.parseInt("" + processString.charAt(processString.length() - 1));
            Process process = (Process)this.processes_.elementAt(processNumber);
            process.destroy();
        }

        private class PopupTrigger
        implements ActionListener {
            private PopupTrigger() {
            }

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.startsWith("Kill process")) {
                    ProcessPopup.this.killProcess(command);
                } else if (command.equals(ApplicationManager.POPUP_REMOVE)) {
                    ProcessPopup.this.source_.removeFromList();
                }
            }
        }
    }

    private class ProcessWaiter
    extends Thread {
        private Process process_ = null;
        private InformationPanel informationPanel_ = null;

        public ProcessWaiter(Process process, InformationPanel informationPanel) {
            this.process_ = process;
            this.informationPanel_ = informationPanel;
        }

        public void run() {
            long startTime = -1L;
            if (ApplicationManager.this.isConnectedToAof() && this.informationPanel_.shouldBeRecorded()) {
                startTime = ApplicationManager.this.getAofRecordTime();
            }
            StreamChecker sc1 = new StreamChecker(this.process_.getInputStream());
            StreamChecker sc2 = new StreamChecker(this.process_.getErrorStream());
            sc1.start();
            sc2.start();
            this.informationPanel_.incrementProcessCount(this.process_);
            try {
                this.process_.waitFor();
            }
            catch (InterruptedException e) {
                System.err.println(e);
                e.printStackTrace();
            }
            this.informationPanel_.decrementProcessCount(this.process_);
            ApplicationManager.this.setStatusMessage("Process '" + this.informationPanel_.getName() + "' terminated.");
            if (ApplicationManager.this.isConnectedToAof() && this.informationPanel_.shouldBeRecorded()) {
                long endTime = ApplicationManager.this.getAofRecordTime();
                ApplicationManager.this.appendToAppevqFile(this.informationPanel_.getNumber(), startTime, endTime);
            }
        }

        private class StreamChecker
        extends Thread {
            InputStream in_;

            public StreamChecker(InputStream in) {
                this.in_ = in;
            }

            public void run() {
                try {
                    InputStreamReader isr = new InputStreamReader(this.in_);
                    BufferedReader br = new BufferedReader(isr);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        System.out.println(" > " + line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class AnimInformationPanel
    extends InformationPanel {
        private String information_ = null;
        private String parameters_ = "";
        private TextArea informationArea_ = null;

        public AnimInformationPanel(String animName, TextArea informationArea) {
            super(animName);
            this.addMouseListener(ApplicationManager.this.animPanelListener_);
            this.informationArea_ = informationArea;
        }

        public void setSelected(boolean selected) {
            if (selected) {
                this.informationArea_.setText(this.getInformation());
            }
            super.setSelected(selected);
        }

        public void setInformation(String[] information) {
            if (information == null) {
                this.information_ = "No information available.";
            } else {
                this.information_ = "";
                int i = 0;
                while (i < information.length) {
                    this.information_ = this.information_ + information[i] + '\n';
                    ++i;
                }
            }
        }

        public String getInformation() {
            return this.information_;
        }

        public void setParameters(String parameters) {
            this.parameters_ = parameters;
        }

        public String getParameters() {
            return this.parameters_;
        }

        protected String[] getCommand() {
            try {
                StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(this.getParameters()));
                tokenizer.resetSyntax();
                tokenizer.whitespaceChars(0, 32);
                tokenizer.wordChars(33, 255);
                tokenizer.quoteChar(34);
                tokenizer.quoteChar(39);
                Vector<String> tmp = new Vector<String>();
                int ttype = tokenizer.ttype;
                while (ttype != -1) {
                    ttype = tokenizer.nextToken();
                    switch (ttype) {
                        case -3: 
                        case 34: 
                        case 39: {
                            tmp.addElement(tokenizer.sval);
                            break;
                        }
                        case -1: {
                            break;
                        }
                        default: {
                            ApplicationManager.this.setStatusMessage("Parsing parameter failed!!!");
                        }
                    }
                }
                String[] cmd = new String[tmp.size() + 2];
                cmd[0] = "java";
                cmd[1] = this.getName();
                int i = 0;
                while (i < tmp.size()) {
                    cmd[i + 2] = (String)tmp.elementAt(i);
                    ++i;
                }
                return cmd;
            }
            catch (IOException e) {
                ApplicationManager.this.setStatusMessage(e.toString());
                e.printStackTrace();
                return null;
            }
        }
    }

    private class AnimPanelListener
    extends MouseAdapter {
        private AnimPanelListener() {
        }

        public void mousePressed(MouseEvent e) {
            AnimInformationPanel source = (AnimInformationPanel)e.getSource();
            ApplicationManager.this.selectAnimPanel(source);
            if (e.isPopupTrigger()) {
                ProcessPopup popup = new ProcessPopup(source.getProcesses(), source);
                source.add(popup);
                popup.show(source, e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
            InformationPanel source = (InformationPanel)e.getSource();
            if (e.isPopupTrigger()) {
                ProcessPopup popup = new ProcessPopup(source.getProcesses(), source);
                source.add(popup);
                popup.show(source, e.getX(), e.getY());
            }
        }
    }

    private class WindowListener
    extends WindowAdapter {
        private WindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }

    private class CheckboxMenuItemListener
    implements ItemListener {
        private CheckboxMenuItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getItemSelectable() == ApplicationManager.this.cbmiJedasAnims_) {
                ApplicationManager.this.cbmiJedasAnims_.setState(true);
                ApplicationManager.this.cbmiScripts_.setState(false);
                ApplicationManager.this.notePadLayout_.show(ApplicationManager.this.notePad_, "jedas");
                ApplicationManager.this.animsMenu_.setEnabled(true);
                ApplicationManager.this.scriptsMenu_.setEnabled(false);
            } else if (e.getItemSelectable() == ApplicationManager.this.cbmiScripts_) {
                ApplicationManager.this.cbmiJedasAnims_.setState(false);
                ApplicationManager.this.cbmiScripts_.setState(true);
                ApplicationManager.this.notePadLayout_.show(ApplicationManager.this.notePad_, "scripts");
                ApplicationManager.this.animsMenu_.setEnabled(false);
                ApplicationManager.this.scriptsMenu_.setEnabled(true);
            } else if (e.getItemSelectable() == ApplicationManager.this.cbmiConnected_) {
                switch (e.getStateChange()) {
                    case 1: {
                        ApplicationManager.this.tryConnectToAof();
                        break;
                    }
                    case 2: {
                        ApplicationManager.this.disconnectFromAof();
                    }
                }
            }
        }
    }

    private class MenuItemListener
    implements ActionListener {
        private MenuItemListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(ApplicationManager.MENU_LOAD_LIST)) {
                ApplicationManager.this.loadSettingsFromFile();
            } else if (command.equals(ApplicationManager.MENU_SAVE_LIST)) {
                ApplicationManager.this.saveSettingsToFile();
            } else if (command.equals(ApplicationManager.MENU_SAVE_LIST_AS)) {
                ApplicationManager.this.saveSettingsAsToFile();
            } else if (command.equals(ApplicationManager.MENU_ANIMS_SCAN)) {
                ApplicationManager.this.scanDirectoryForAnimations();
            } else if (command.equals(ApplicationManager.MENU_ANIMS_INSERT)) {
                ApplicationManager.this.insertAnimation();
            } else if (command.equals(ApplicationManager.MENU_ANIMS_REMOVE)) {
                ApplicationManager.this.removeSelectedAnimation();
            } else if (command.equals(ApplicationManager.MENU_ANIMS_START)) {
                ApplicationManager.this.startSelectedAnimation();
            } else if (command.equals(ApplicationManager.MENU_SCRIPTS_INSERT)) {
                ApplicationManager.this.insertScript();
            } else if (command.equals(ApplicationManager.MENU_SCRIPTS_REMOVE)) {
                ApplicationManager.this.removeSelectedScript();
            } else if (command.equals(ApplicationManager.MENU_SCRIPTS_START)) {
                ApplicationManager.this.startSelectedScript();
            } else if (command.equals(ApplicationManager.MENU_QUIT)) {
                System.exit(0);
            }
        }
    }

    private class ClassFileFilter
    implements FilenameFilter {
        private ClassFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".class");
        }
    }

    private class NotJedasAnimationException
    extends Exception {
        public NotJedasAnimationException(String message) {
            super(message);
        }
    }

    private class AppsFilenameFilter
    implements FilenameFilter {
        private AppsFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".appini");
        }
    }
}

