/*
 * Decompiled with CFR 0.152.
 */
package mlb.xml;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import mlb.xml.XmlFormatException;

public class XmlParser {
    public static final int EOF = -1;
    public static final int TAG_START = 0;
    public static final int TAG_END = 1;
    public static final int PROPERTY = 2;
    public static final int BOOL_PROPERTY = 3;
    public static final int CONTENT = 4;
    private StreamTokenizer tokenizer_;
    private Reader reader_;
    private boolean isInsideTag_ = false;
    private boolean tokenPending_ = false;
    private String token_ = "";
    private String propertyOfToken_ = "";

    public XmlParser(InputStream in) {
        this(new BufferedReader(new InputStreamReader(in)));
    }

    public XmlParser(String fileName) throws IOException {
        this(new FileReader(fileName));
    }

    public XmlParser(Reader reader) {
        this.reader_ = reader;
        this.tokenizer_ = new StreamTokenizer(this.reader_);
        this.tokenizer_.slashSlashComments(false);
        this.tokenizer_.slashStarComments(false);
        this.tokenizer_.eolIsSignificant(false);
        this.tokenizer_.ordinaryChars(60, 62);
        this.tokenizer_.ordinaryChar(47);
        this.tokenizer_.quoteChar(34);
        this.tokenizer_.quoteChar(39);
    }

    public int getNextTag() throws XmlFormatException, IOException {
        int result = -1;
        boolean isFirstWordInTag = false;
        boolean isWaitingForProperty = false;
        boolean isEndTag = false;
        char expectedChar = '\u0000';
        boolean ready = false;
        block12: while (!ready) {
            int ttype;
            if (!this.tokenPending_) {
                ttype = this.tokenizer_.nextToken();
            } else {
                ttype = this.tokenizer_.ttype;
                this.tokenPending_ = false;
            }
            block0 : switch (ttype) {
                case -1: {
                    if (expectedChar != '\u0000') {
                        throw new XmlFormatException("Expected character '" + expectedChar + "', got TT_EOF");
                    }
                    if (isWaitingForProperty) {
                        throw new XmlFormatException("Expected property, got TT_EOF");
                    }
                    result = -1;
                    ready = true;
                    break;
                }
                case -3: 
                case 34: 
                case 39: {
                    if (expectedChar != '\u0000') {
                        if (expectedChar == '=') {
                            result = 3;
                            this.tokenPending_ = true;
                            break;
                        }
                        throw new XmlFormatException("Expected character '" + expectedChar + "', got TT_WORD");
                    }
                    if (isFirstWordInTag) {
                        if (!isEndTag) {
                            result = 0;
                            this.setToken(this.tokenizer_.sval);
                            ready = true;
                        } else {
                            result = 1;
                            this.setToken(this.tokenizer_.sval);
                            ready = true;
                            isEndTag = false;
                        }
                        isFirstWordInTag = false;
                        break;
                    }
                    if (this.isInsideTag_) {
                        if (!isWaitingForProperty) {
                            this.setToken(this.tokenizer_.sval);
                            expectedChar = '=';
                            break;
                        }
                        this.setPropertyOfToken(this.tokenizer_.sval);
                        isWaitingForProperty = false;
                        result = 2;
                        ready = true;
                        break;
                    }
                    result = 4;
                    this.setToken(this.tokenizer_.sval);
                    ready = true;
                    break;
                }
                case -2: {
                    if (expectedChar != '\u0000') {
                        throw new XmlFormatException("Expected character '" + expectedChar + "', got TT_NUMBER.");
                    }
                    if (isWaitingForProperty) {
                        throw new XmlFormatException("Expected property, got TT_NUMBER.");
                    }
                    System.out.println("Hmm? TT_NUMBER!");
                    break;
                }
                case 10: {
                    if (expectedChar != '\u0000') {
                        throw new XmlFormatException("Expected character '" + expectedChar + "', got TT_EOL.");
                    }
                    if (isWaitingForProperty) {
                        throw new XmlFormatException("Expected property, got TT_EOL.");
                    }
                    System.out.println("Hmm? TT_EOL!");
                    break;
                }
                default: {
                    if (isWaitingForProperty) {
                        throw new XmlFormatException("Expected property, got character '" + (char)ttype + "'.");
                    }
                    if (expectedChar == '=' && (char)ttype == '>') {
                        result = 3;
                        expectedChar = '\u0000';
                        ready = true;
                    }
                    if (expectedChar != '\u0000' && expectedChar != (char)ttype) {
                        throw new XmlFormatException("Expected character '" + expectedChar + "', got '" + (char)ttype + "'.");
                    }
                    switch (ttype) {
                        case 60: {
                            this.isInsideTag_ = true;
                            isFirstWordInTag = true;
                            break block0;
                        }
                        case 61: {
                            expectedChar = '\u0000';
                            isWaitingForProperty = true;
                            break block0;
                        }
                        case 62: {
                            this.isInsideTag_ = false;
                            break block0;
                        }
                        case 47: {
                            if (!this.isInsideTag_) continue block12;
                            isEndTag = true;
                            break block0;
                        }
                        default: {
                            throw new XmlFormatException("Received unknown ordinary character '" + (char)ttype + "'.");
                        }
                    }
                }
            }
        }
        return result;
    }

    private void setToken(String token) {
        this.token_ = token;
    }

    public String getToken() {
        return this.token_;
    }

    private void setPropertyOfToken(String propertyOfToken) {
        this.propertyOfToken_ = propertyOfToken;
    }

    public String getPropertyOfToken() {
        return this.propertyOfToken_;
    }
}

