/*
 * Created on 19.01.2004 13:50:58
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package evalplayer;

//import jedas.annotate.*;
//import jedas.io.*;
//import jedas.*;

import mauda.*;
import mauda.utils.MyWindowListener;
import mauda.utils.FileLocation;
import mauda.evaluation.*;

import javax.swing.*;
import java.awt.*;

/**
 * The main-program for the Evaluation-Player<br><br>
 * The Evaluation-Player is needed to play recorded, by a tutor
 * evaluated exercises in Evaluation-Editor.
 * 
 * @author Markus Krebs
 */
public class EvalPlayer extends JFrame implements ExerciseUpdateListener {
	
	private String frameTitle = "MA&DA EvalPlayer V1.00";
	
	/**
	 * Starts the Evaluation-Player
	 * 
	 * @param args Handles no arguments
	 */
	public static void main(String args[]) {
		//Prop.load("eng");	// Properties laden
		new EvalPlayer();
	}
	
	/**
	 * Creates the main-Frame for the Evaluation-Player
	 */
	public EvalPlayer() {
		
		MAUDA.setApplicationMainFrame(this);
		
		FileLocation.config();
		
		//setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

		// WorkEditor mit FibHeap-PlugIn starten
		// wird spter beim Laden von anderen Aufgaben sowieso
		// angepasst
		PlayerExercise exercise = new PlayerExercise("FibHeap");
		exercise.addExerciseUpdateListener(this);
		exercise.setInteractiveMode(Exercise.NOPOPUP);

		// ModifiedDetector anmelden
		exercise.addExerciseUpdateListener(new ModifiedDetector(exercise));

		// WindowListener
		// fr ev. ungespeicherte nderungen
		addWindowListener(new MyWindowListener(exercise));
				
		// Grafisches / Layout
		Container contentPane = getContentPane();

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
				
		MenuToolBarListener menuToolBarListener = new MenuToolBarListener(exercise);
		mainPanel.add(new TopToolBar(menuToolBarListener), BorderLayout.NORTH);
			
		// MenuBar
		setMenuBar(new EvalPlayerMenu(menuToolBarListener));
		
		// Panel rechts
		JPanel rightPanel = new JPanel();
		rightPanel.setLayout(new BorderLayout());
		JSplitPane sp = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		sp.setTopComponent(exercise.getTreeOperationView().getPanel());
		
		// NEU
		JPanel bottomPanel = new JPanel();
		bottomPanel.setLayout(new BorderLayout());
		
		bottomPanel.add(exercise.getCommentView().getPanel(), BorderLayout.CENTER);
		bottomPanel.add(new SpeedSlider().getPanel(), BorderLayout.SOUTH);
		sp.setBottomComponent(bottomPanel);
		// ALT
		//sp.setBottomComponent(exercise.getTreeOperationView().getPanel());
		
		sp.setOneTouchExpandable(true);
		sp.setDividerLocation(350);	// war vorher 100 (als CommentView oberhalb war)
		rightPanel.add(sp, BorderLayout.CENTER);

		// OP-PANEL und JEDAS-PANEL zusammenbringen
		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		splitPane.setRightComponent(rightPanel);
		
		JPanel leftPanel = new JPanel();
		leftPanel.setLayout(new BorderLayout());
		leftPanel.add(exercise.jedasPanel, BorderLayout.CENTER);
		TimeSlider timeSlider = new TimeSlider(exercise);
		leftPanel.add(timeSlider.getPanel(), BorderLayout.SOUTH);
		
		splitPane.setLeftComponent(leftPanel);
		//splitPane.setLeftComponent(new JLabel("Player Panel"));
		//splitPane.setLeftComponent(Exercise.compPanel.getDrawPanel());
		//EvalPlayer.setCompPanel(Exercise.compPanel);
		
		splitPane.setOneTouchExpandable(true);
		// Notwendig, damit verschieben nach links funktioniert
		rightPanel.setMinimumSize(new Dimension(240,50));
		//exercise.jedasPanel.setMinimumSize(new Dimension(280, 50));

		mainPanel.add(splitPane, BorderLayout.CENTER);

		contentPane.add(mainPanel, BorderLayout.CENTER);
		
		setBounds(0, 0, 800, 550);
		//setBounds(600, 0, 240, 550);
		setTitle(frameTitle);
		splitPane.setDividerLocation(540);	// 800-240 (-20)
		//splitPane.setDividerLocation(0);
		
		MetaData.setDisplayMode(MetaData.EDITOR);
		
		jedas.Jedas.setApplicationMainFrame(this);
		
		exercise.jedasPanel.setMessage("Please load an exercise...");
				
		setVisible(true);
	}
	
	/* (non-Javadoc)
	 * @see mauda.ExerciseUpdateListener#exerciseUpdate(mauda.ExerciseUpdateEvent)
	 */
	public void exerciseUpdate(ExerciseUpdateEvent e) {
		if(e.getID() != ExerciseUpdateEvent.FILENAME_CHANGED) return;
		// Nur Dateiname anzeigen (ohne Pfad)
		String filename = e.getExercise().getFilename();
		filename = filename.replace('\\', '/');
		filename = filename.substring(filename.lastIndexOf("/")+1);
		setTitle(filename + " - " + frameTitle);
	}
	

}