/*
 * Created on 11.01.2004 15:53:10
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package evalplayer;

import mauda.utils.Prop;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * MenuBar
 * 
 * @author Markus Krebs
 */
public class EvalPlayerMenu extends MenuBar {

	private EventListener actionListener;

	private Menu file = new Menu(Prop.get(this, "File"));
	private Menu info = new Menu(Prop.get(this, "Information"));
	/**
	 * Creates the menu
	 * @param al The listener for the menu
	 */
	public EvalPlayerMenu(EventListener al) {
		super();
		
		actionListener = al;
		
		addMI(file, ActionCommands.openFile);
		addMI(file, ActionCommands.meta);
		file.addSeparator();
		addMI(file, ActionCommands.exit);
		
		add(file);

		addMI(info, ActionCommands.showAbout);
		addMI(info, ActionCommands.showHelp);
		add(info);
}
	/**
	 * Adds a menu-item to the menu
	 * @param m The menu to add the item
	 * @param text The ActionCommand of the menu-item
	 * @see evalplayer.ActionCommands
	 */
	private void addMI(Menu m, String text) {
		String label = Prop.get(this, text);
		MenuItem mi = new MenuItem(label);
		mi.addActionListener((ActionListener)actionListener);
		mi.setActionCommand(text);
		m.add(mi);
	}
}
