/*
 * Created on 19.01.2004 13:50:58
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package evaluation;

import jedas.annotate.*;
import jedas.io.Recorder;	// Subclassing von Recorder geht leider nicht (Jedas.setRecording() macht "new Recorder()")
import jedas.Jedas;

import mauda.*;
import mauda.utils.MyWindowListener;
import mauda.utils.FileLocation;
import mauda.evaluation.EvalExercise;
import mauda.jedasnew.RecordFrame;
//import jedas.io.RecordFrame;

import javax.swing.*;
import java.awt.*;

/**
 * The main-frame for the Evaluation-Editor<br><br>
 * The Evaluation-Editor is a editor for an tutor to evaluate an
 * exercise that was not automatically evaluated in the Working-
 * Editor (e.g.: when feedback-type is NoTutor)
 * 
 * @author Markus Krebs
 */
public class EvalEditor extends JFrame implements ExerciseUpdateListener {
	private AnnotationFrame annotationFrame;
	private RecordFrame recordFrame;
	
	private String frameTitle = "MA&DA EvalEditor V1.00";

	/**
	 * Starts the Evaluation-Editor
	 * @param args
	 */
	public static void main(String args[]) {
		//Prop.load("eng");	// Properties laden
		new EvalEditor();
	}
	
	/**
	 * Creates the main-frame for the Evaluation-Editor
	 */
	public EvalEditor() {
		
		MAUDA.setApplicationMainFrame(this);
		
		FileLocation.config();
		
		//setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

		// WorkEditor mit FibHeap-PlugIn starten
		// wird spter beim Laden von anderen Aufgaben sowieso
		// angepasst
		EvalExercise exercise = new EvalExercise("FibHeap");
		exercise.addExerciseUpdateListener(this);
		exercise.setInteractiveMode(Exercise.NOPOPUP);

		// ModifiedDetector anmelden
		exercise.addExerciseUpdateListener(new ModifiedDetector(exercise));

		// WindowListener
		// fr ev. ungespeicherte nderungen
		addWindowListener(new MyWindowListener(exercise));
				
		// Grafisches / Layout
		Container contentPane = getContentPane();

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
				
		MenuToolBarListener menuToolBarListener = new MenuToolBarListener(exercise);
		mainPanel.add(new TopToolBar(menuToolBarListener), BorderLayout.NORTH);
			
		// MenuBar
		setMenuBar(new EvalEditorMenu(menuToolBarListener));
		
		// Panel rechts
		JPanel rightPanel = new JPanel();
		rightPanel.setLayout(new BorderLayout());
		JSplitPane sp = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		
		sp.setBottomComponent(exercise.getCommentView().getPanel());
		sp.setTopComponent(exercise.getTreeOperationView().getPanel());
		
		sp.setOneTouchExpandable(true);
		sp.setDividerLocation(350);	// war vorher 100 (als CommentView oberhalb war)
		rightPanel.add(sp, BorderLayout.CENTER);

		// OP-PANEL und JEDAS-PANEL zusammenbringen
		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		splitPane.setRightComponent(rightPanel);
		splitPane.setLeftComponent(exercise.jedasPanel);
		splitPane.setOneTouchExpandable(true);
		//splitPane.setDividerLocation(0.7);
		// Notwendig, damit verschieben nach links funktioniert
		rightPanel.setMinimumSize(new Dimension(240,50));
		exercise.jedasPanel.setMinimumSize(new Dimension(280, 50));

		mainPanel.add(splitPane, BorderLayout.CENTER);
		
		contentPane.add(mainPanel, BorderLayout.CENTER);
		
		//setBounds(0, 160, 800, 500);	// <- wie bei GenEditor
		setBounds(0, 0, 800, 550);
		setTitle(frameTitle);
		splitPane.setDividerLocation(540);	// 800-240 (-20)
		
		MetaData.setDisplayMode(MetaData.EDITOR);
		
		jedas.Jedas.setApplicationMainFrame(this);

		
		annotationFrame = new AnnotationFrame(Exercise.scheduler, Exercise.compPanel );

		// ALT
		//jedas.io.RecordFrame recordFrame = new jedas.io.RecordFrame();
		// NEU
		recordFrame = new RecordFrame();
		recordFrame.setExercise(exercise);
		
		annotationFrame.setLocation(new Point(0,0));
		recordFrame.setLocation(new Point(0,annotationFrame.getHeight()));
		setLocation(new Point(annotationFrame.getWidth(),0));
		
		// Aktivieren des Hauptfensters => andere sichtbar machen
		final Frame mf = this;	// Bei jedem WindowEvent checken
		addWindowStateListener(new java.awt.event.WindowAdapter() {
			private int oldState = 0;
			public void windowStateChanged(java.awt.event.WindowEvent e) {
				int state = mf.getState();
				if(state != oldState) {
					oldState = state;
					annotationFrame.setState(state);
					recordFrame.setState(state);
					mf.toFront();
					mf.requestFocus();
				}
			}
		});
				
		exercise.jedasPanel.setMessage("Please load an exercise...");
		
		setVisible(true);
		
		// Immer nach zuerst nach jedasRecordingFilename abspeichern
		// Datei wird spter beim Speichern verschoben
		Recorder recorder = Jedas.getRecorder();
		Recorder.setFileName(FileLocation.jedasRecordingFilename);
	}
	
	/* (non-Javadoc)
	 * @see mauda.ExerciseUpdateListener#exerciseUpdate(mauda.ExerciseUpdateEvent)
	 */
	public void exerciseUpdate(ExerciseUpdateEvent e) {
		if(e.getID() != ExerciseUpdateEvent.FILENAME_CHANGED) return;
		// Nur Dateiname anzeigen (ohne Pfad)
		String filename = e.getExercise().getFilename();
		filename = filename.replace('\\', '/');
		filename = filename.substring(filename.lastIndexOf("/")+1);
		setTitle(filename + " - " + frameTitle);
	}
}