/*
 * Created on 09.11.2003 21:25:05
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package generation;

import mauda.*;
import mauda.utils.MyWindowListener;
import mauda.plugin.PlugInHandler;
import mauda.utils.FileLocation;
import mauda.generation.GenExercise;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.util.*;

/**
 * The main-frame for the Generation-Editor<br><br>
 * The Generation-Editor is a program to create exercises by a
 * person.
 * 
 * @author Markus Krebs
 */
public class GenEditor extends JFrame implements ExerciseUpdateListener {
	
	private static String frameTitle = "MA&DA GenEditor V1.00";

	/**
	 * Starts the Generation-Editor
	 * @param args
	 */
	public static void main(String args[]) {
		//Prop.load("eng");	// Properties laden
		new GenEditor();
	}
	
	/**
	 * Creates the Generation-Editor
	 */
	public GenEditor() {
		
		MAUDA.setApplicationMainFrame(this);
		
		FileLocation.config();
		
		//setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

		GenExercise exercise = new GenExercise("FibHeap");
		exercise.addExerciseUpdateListener(this);
		
		// ModifiedDetector anmelden
		exercise.addExerciseUpdateListener(new ModifiedDetector(exercise));

		// WindowListener
		// fr ev. ungespeicherte nderungen
		addWindowListener(new MyWindowListener(exercise));

		MenuToolBarListener menuToolBarListener = new MenuToolBarListener(exercise);
		GeneratorMenu generatorMenu = new GeneratorMenu(menuToolBarListener);
		PlugInHandler pih = exercise.getPlugInHandler();
		String[] pinames = pih.getAvailablePlugIns();
		for(int i=0; i<pinames.length; i++) {
			String id = pinames[i];
			generatorMenu.addPlugIn(id, pih.getPlugInString(id));
		}


		// Grafisches / Layout
		Container contentPane = getContentPane();

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		
		// OP-PANEL
		JPanel opPanel = new JPanel();
		opPanel.setLayout(new BorderLayout());

		JTabbedPane tabbedPane = new JTabbedPane();

		// Beim Anklicken Daten aktualisieren
		tabbedPane.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				JTabbedPane tp = (JTabbedPane)e.getSource();
				EditTab et = (EditTab)tp.getSelectedComponent();
				et.doUpdate();
			}
		});
				
		// Die EditTabs ===============================================
		EditTab exerciseTab = new ExerciseTab(exercise);
		EditTab operationsTab = new OperationsTab(exercise);
		EditTab ratingTab = new RatingTab(exercise);
		EditTab initTab = new InitTab(exercise);
		EditTab scrambleTab = new ScrambleTab(exercise);
		EditTab autoGenTab = new AutoGenTab(exercise);
		tabbedPane.add(exerciseTab.getTabName(), exerciseTab);
		tabbedPane.add(operationsTab.getTabName(), operationsTab);
		tabbedPane.add(ratingTab.getTabName(), ratingTab);
		tabbedPane.add(initTab.getTabName(), initTab);
		tabbedPane.add(scrambleTab.getTabName(), scrambleTab);
		tabbedPane.add(autoGenTab.getTabName(), autoGenTab);
		
		exercise.addExerciseUpdateListener(exerciseTab);
		exercise.addExerciseUpdateListener(operationsTab);
		exercise.addExerciseUpdateListener(ratingTab);
		exercise.addExerciseUpdateListener(initTab);
		exercise.addExerciseUpdateListener(scrambleTab);
		exercise.addExerciseUpdateListener(autoGenTab);		
	
		Vector editTabs = new Vector();
		editTabs.add(initTab);
		editTabs.add(scrambleTab);
		editTabs.add(autoGenTab);
		menuToolBarListener.setEditTabs(editTabs);
		mainPanel.add(new TopToolBar(menuToolBarListener), BorderLayout.NORTH);
		// ==========================================================
			
		opPanel.add(tabbedPane, BorderLayout.CENTER);

		// OP-PANEL und JEDAS-PANEL zusammenbringen
		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		splitPane.setBottomComponent(opPanel);
		splitPane.setTopComponent(exercise.jedasPanel);
		splitPane.setOneTouchExpandable(true);
		//splitPane.setDividerLocation(0.7);
		
		// Notwendig, damit verschieben nach links funktioniert
		opPanel.setMinimumSize(new Dimension(220,50));
		exercise.jedasPanel.setMinimumSize(new Dimension(280, 50));
		
		mainPanel.add(splitPane, BorderLayout.CENTER);


		contentPane.add(mainPanel, BorderLayout.CENTER);
		
		setMenuBar(generatorMenu);

		setBounds(0, 0, 800, 500);
		setTitle(frameTitle);

		setVisible(true);
		
		MetaData.setDisplayMode(MetaData.CREATOR);

	}
	/* (non-Javadoc)
	 * @see mauda.ExerciseUpdateListener#exerciseUpdate(mauda.ExerciseUpdateEvent)
	 */
	public void exerciseUpdate(ExerciseUpdateEvent e) {
		if(e.getID() != ExerciseUpdateEvent.FILENAME_CHANGED) return;
		// Nur Dateiname anzeigen (ohne Pfad)
		String filename = e.getExercise().getFilename();
		filename = filename.replace('\\', '/');
		filename = filename.substring(filename.lastIndexOf("/")+1);
		setTitle(filename + " - " + frameTitle);
	}
}