/*
 * Created on 11.01.2004 15:53:10
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package generation;

import mauda.Difficulties;
import mauda.utils.Prop;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * MenuBar for the generation-editor
 * 
 * @author Markus Krebs
 */
public class GeneratorMenu extends MenuBar {

	private EventListener actionListener;

	private Menu switchTo = new Menu(Prop.get(this, "SwitchTo"));
	private Menu file = new Menu(Prop.get(this, "File"));
	private Menu edit = new Menu(Prop.get(this, "Edit"));
	private Menu mode = new Menu(Prop.get(this, "Mode"));
	private Menu diff = new Menu(Prop.get(this, "Difficulty"));
	private Menu info = new Menu(Prop.get(this, "Information"));

	/**
	 * Creates the menu
	 * @param al The listener for the menu
	 */
	public GeneratorMenu(EventListener al) {
		super();
		
		actionListener = al;
		
		add(switchTo);
		
		addMI(file, ActionCommands.newFile);
		addMI(file, ActionCommands.openFile);
		addMI(file, ActionCommands.saveFile);
		addMI(file, ActionCommands.saveAsFile);
		addMI(file, ActionCommands.meta);
		addMI(file, ActionCommands.automatic);
		file.addSeparator();
		addMI(file, ActionCommands.exit);
		add(file);
		
		addMI(edit, ActionCommands.undo);
		addMI(edit, ActionCommands.redo);
		edit.addSeparator();
		addCMI(edit, ActionCommands.subOperationEdit);
		add(edit);
		
		addMI(mode, ActionCommands.normalMode);
		addMI(mode, ActionCommands.faultMode);
		add(mode);
		
		addMIDifficulty(diff, ActionCommands.difficulty0, Difficulties.EASY);
		addMIDifficulty(diff, ActionCommands.difficulty1, Difficulties.MEDIUM);
		addMIDifficulty(diff, ActionCommands.difficulty2, Difficulties.HARD);
		add(diff);
		
		addMI(info, ActionCommands.showAbout);
		addMI(info, ActionCommands.showHelp);
		add(info);
	}
	// Normales MenuItem hinzufgen
	private void addMI(Menu m, String text) {
		String label = Prop.get(this, text);
		MenuItem mi = new MenuItem(label);
		mi.addActionListener((ActionListener)actionListener);
		mi.setActionCommand(text);
		m.add(mi);
	}
	// Hinzufgen eines Difficulty-Menu-Items
	private void addMIDifficulty(Menu m, String ac, int d) {
		String label = Difficulties.getGUIString(d);
		MenuItem mi = new MenuItem(label);
		mi.addActionListener((ActionListener)actionListener);
		mi.setActionCommand(ac);
		m.add(mi);		
	}
	// Checkbox-MenuItem hinzufgen
	private void addCMI(Menu m, String text) {
		String label = Prop.get(this, text);
		CheckboxMenuItem cmi = new CheckboxMenuItem(label);
		cmi.addItemListener((ItemListener)actionListener);
		cmi.setActionCommand(text);
		m.add(cmi);
	}
	// PlugIn-Auswahl-Menu: Item hinzufgen
	// ID = FibHeap / String = Fibonacci-Heap
	protected void addPlugIn(String plugInID, String plugInString) {
		MenuItem mi = new MenuItem(plugInString);
		mi.addActionListener((ActionListener)actionListener);
		mi.setActionCommand("PLUGIN: "+plugInID);
		switchTo.add(mi);
	}
}
