/*
 * Created on 08.12.2003 20:22:35
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package generation;

import mauda.generation.*;
import mauda.operation.*;
import mauda.plugin.*;

/**
 * pane for operations from which to generate the initial-state for exercise
 * 
 * @author Markus Krebs
 */
public class InitTab extends OpTemplateTab {

	protected static final String tabName = "Init";

	private String initFilename = "init.xml";	// Dateiname fr Laden/Speichern

	/**
	 * Constructs a panel to view the operations
	 * @param exercise
	 */
	public InitTab(GenExercise exercise) {
		super(exercise);
		setTabName(tabName);
		updateSettings();
	}
	protected void executePressed(GenExercise ex) {
		OperationQueue oq = GeneralAnalyst.init(ex.getDSObject(), operationQueue, ex.getDifficulty(),ex.getMode());
		if(oq==null) { showNotSupportedDialog(); return; }
		exercise.commit(oq);
	}
	protected void updateSettings() {
		super.updateSettings();
		setDataFilename(initFilename);
		loadConfig(dataFilename);
	}
}
