/*
 * Created on 08.12.2003 20:10:46
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package generation;

import mauda.generation.*;
import mauda.operation.*;
import mauda.plugin.*;

/**
 * pane for operations from which to scramble the current 
 * data-structure
 * 
 * @author Markus Krebs
 */
public class ScrambleTab extends OpTemplateTab {

	protected static final String tabName = "Scramble";

	protected String scrambleFilename = "scramble.xml";	// Dateiname fr Laden/Speichern

	/**
	 * Constructs a panel to view the operations
	 * @param exercise GenExercise
	 */
	public ScrambleTab(GenExercise exercise) {
		super(exercise);
		setTabName(tabName);
		updateSettings();
	}
	protected void executePressed(GenExercise ex) {
		OperationQueue oq = GeneralAnalyst.scramble(ex.getDSObject(), operationQueue, ex.getDifficulty(), ex.getMode());
		if(oq==null) { showNotSupportedDialog(); return; }
		ex.commit(oq);
	}
	protected void updateSettings() {
		super.updateSettings();
		setDataFilename(scrambleFilename);
		loadConfig(dataFilename);		
	}
}
