/*
 * Created on 08.12.2003 14:34:39
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package generation;

import mauda.utils.Prop;
import mauda.images.ImageHandler;

import javax.swing.*;

import java.awt.event.*;
/**
 * Generates the top-toolbar for generation-editor
 * 
 * @author Markus Krebs
 */
public class TopToolBar extends JToolBar {

	private ActionListener actionListener;

	/**
	 * Creates the toolbar
	 * @param al The listener for actions
	 */
	public TopToolBar(ActionListener al) {
		super();
		
		actionListener = al;
		
		//this.exercise = exercise;
		//this.editTabs = editTabs;
		
		createButton(ActionCommands.newFile);
		createButton(ActionCommands.openFile);
		createButton(ActionCommands.saveFile);
		createButton(ActionCommands.saveAsFile);
		createButton(ActionCommands.dump);
		createButton(ActionCommands.meta);
		addSeparator();
		createButton(ActionCommands.automatic);
		addSeparator();
		createButton(ActionCommands.undo);
		createButton(ActionCommands.redo);
		
		/*
		addSeparator();
		add(new JLabel(Prop.get(difficulty)+": "));
		difficultyButton = createButton(difficulty);
		difficultyButton.setText(Difficulties.getDifficultyGUIString(exercise.getDifficulty()));
		addSeparator();
		*/
		
		/*
		JCheckBox faultCB = new JCheckBox(Prop.get(faultMode));
		faultCB.setSelected(false);
		faultCB.setActionCommand(faultMode);
		faultCB.addActionListener(this);
		add(faultCB);*/
		
		/*
		addSeparator();
		
		add(new JLabel(Prop.get("Filename")));
		addSeparator();
		filename = defaultFilename;
		filenameLabel = new JLabel(filename);
		add(filenameLabel);
		*/		

		addSeparator();
		
		createButton(ActionCommands.showHelp);
}
	// Button hinzufgen
	protected JButton createButton(String text) {
		String buttonText = Prop.get(this, text);
		String imgfname = Prop.get(this, text+"Image");
		JButton button = null;
		if(imgfname.equals("NONE")) {
			button = new JButton(buttonText);
		} else {
			ImageIcon ii = ImageHandler.createImageIcon(imgfname);
			//button = new JButton(new ImageIcon("images/"+imgfname));
			button = new JButton(ii);			
			button.setMargin(new java.awt.Insets(2,2,2,2));
			button.setToolTipText(buttonText);
		}
		button.addActionListener(actionListener);
		button.setActionCommand(text);
		add(button);
		return button;
	}
}
