/*
 * Created on 03.08.2004 10:29:46
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package help;

import javax.swing.*;

import mauda.images.ImageHandler;

import java.awt.*;
import java.awt.event.*;

/**
 * Handles the Help-System of the MAUDA-Project.
 * 
 * @author Markus Krebs
 */
public class HelpFrame extends JFrame implements ActionListener {

	private String frameTitle = "MA&DA Help V1.00";
	
	private static HelpFrame instance = null;
	
	private HelpTree helpTree;
	
	private JButton backButton;
	private JButton forwardButton;
	
	private JButton undoButton;
	private JButton redoButton;
	private JButton exitButton;
	
	/**
	 * Creates a new Frame containing the help-pages. This constructor should not be
	 * called manually.
	 * @see HelpFrame#createAndShowGUI()
	 */
	public HelpFrame() {
		super();
		
		//HelpTree.setView(HelpTree.EVALEDITOR_VIEW);

		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				instance = null;
				dispose();
			}
		}
		);
		//setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);

		Container contentPane = getContentPane();
		contentPane.setLayout(new BorderLayout());
		
		JEditorPane editorPane = new JEditorPane();
		editorPane.setEditable(false);

		helpTree = new HelpTree(editorPane);
		
		// Obere Leiste
		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		
		//exitButton = new JButton(ImageHandler.createImageIcon("Exit16.gif"));
		exitButton = new JButton("Exit");

		backButton = new JButton(ImageHandler.createImageIcon("Back16.gif"));
		forwardButton = new JButton(ImageHandler.createImageIcon("Forward16.gif"));
		
		undoButton = new JButton(ImageHandler.createImageIcon("Undo16.gif"));
		redoButton = new JButton(ImageHandler.createImageIcon("Redo16.gif"));
		
		backButton.addActionListener(this);
		forwardButton.addActionListener(this);
		undoButton.addActionListener(this);
		redoButton.addActionListener(this);
		exitButton.addActionListener(this);
		
		buttonPanel.add(exitButton);
		buttonPanel.add(new JSeparator());
		buttonPanel.add(backButton);
		buttonPanel.add(forwardButton);
		buttonPanel.add(new JSeparator());
		buttonPanel.add(undoButton);
		buttonPanel.add(redoButton);
		
		contentPane.add(buttonPanel, BorderLayout.NORTH);
		
		// Hauptbereich (Help-Inhalte)
		JPanel leftPanel = new JPanel();
		leftPanel.setLayout(new BorderLayout());
		leftPanel.add(new JScrollPane(helpTree.getPanel()), BorderLayout.CENTER);
		
		JPanel rightPanel = new JPanel();
		rightPanel.setLayout(new BorderLayout());
		rightPanel.add(new JScrollPane(editorPane), BorderLayout.CENTER);
		
		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		splitPane.setLeftComponent(leftPanel);
		splitPane.setRightComponent(rightPanel);

		leftPanel.setMinimumSize(new Dimension(100,50));
		rightPanel.setMinimumSize(new Dimension(100,50));

		contentPane.add(splitPane, BorderLayout.CENTER);
		
		// Fenster-Eigenschaften
		setBounds(mauda.MAUDA.getRelativeBounds(800,550));
		//setBounds(0, 0, 800, 550);
		setTitle(frameTitle);
		splitPane.setDividerLocation(200);
		
		setVisible(true);
		
		instance = this;
		
	}
	
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		JButton button = (JButton)e.getSource();
		if(button == exitButton) {
			instance = null;
			dispose();	// Fenster schlieen
		} else if(button == backButton) {
			helpTree.back();
		} else if(button == forwardButton) {
			helpTree.forward();
		} else if(button == undoButton) {
			helpTree.undo();
		} else if(button == redoButton) {
			helpTree.redo();
		}
	}

	/**
	 * Creates a new Frame containing the help-pages. To control the content of the
	 * help-tree use HelpTree.setView(int).
	 * @see HelpTree#setView(int)
	 */
	public static void createAndShowGUI() {
		// GUI nur neu erstellen, wenn es noch nicht offen ist
		if(instance == null) new HelpFrame();
		else {
			instance.setExtendedState(Frame.NORMAL);	// falls ICONIFIED
			instance.toFront();	// falls im Hintergrund
		}
	}
	
	/**
	 * Method to run the help-system directly. 
	 * @param args nothing
	 */
	public static void main(String[] args) {
		HelpTree.setView(HelpTree.COMPLETE_VIEW);
		new HelpFrame();
	}
}
