/*
 * Created on 03.08.2004 11:04:02
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package help;

import java.net.URL;
import java.io.File;
import java.net.MalformedURLException;

/**
 * Handles the properties of one single entry in the tree.
 * 
 * @author Markus Krebs
 */
public class HelpInfo {
    private String title;
    private URL helpURL;

    /**
     * Creates a new entry.
     * @param title The title of the entry.
     * @param filename The url to the to displayed content.
     */
    public HelpInfo(String title, String filename) {
        this.title = title;
        // NEU
        //filename = "D:\\EigeneDateien\\DIPLOMARBEIT\\MAUDA-Application-Help\\helphtml\\"+filename;
        filename = "helphtml/"+filename;
        File file = new File(filename);
        if(!file.exists()) {
        	helpURL = null;
        	System.out.println("'"+filename+"' not exists!");
        	return;
        }
        try {
        	helpURL = file.toURI().toURL();
        } catch(MalformedURLException ex) {
        	ex.printStackTrace();
        }
        // ALT
        //helpURL = HelpInfo.class.getResource(filename);
        if (helpURL == null) {
            System.err.println("Couldn't find file: "
                               + filename);
        }
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return title;
    }
    
    /**
     * Returns the URL.
     * @return URL
     */
    public URL getURL() { return helpURL; }

}
