/*
 * Created on 03.08.2004 10:29:46
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda;

import javax.swing.*;

import mauda.images.ImageHandler;

import java.awt.*;
import java.awt.event.*;

/**
 * Displays an about-frame.
 * 
 * @author Markus Krebs
 */
public class AboutFrame extends JFrame {

	private String frameTitle = "MA&DA About";
	
	private static AboutFrame instance = null;
	
	private JButton exitButton;
	
	/**
	 * Creates an about-frame. Please use createAndShowGUI()
	 * @see AboutFrame#createAndShowGUI()
	 */
	public AboutFrame() {
		super();
		
		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				instance = null;
				dispose();
			}
		}
		);
		//setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);

		Container contentPane = getContentPane();
		contentPane.setLayout(new BorderLayout());
		
		JLabel label = new JLabel(ImageHandler.createImageIcon("about.png"));
		//JLabel label = new JLabel("Mulitmediale Algorithmen und Datenstrukturen Assessments");
		//label.setFont(new Font("Arial", Font.BOLD, 16));
		//contentPane.add(label, BorderLayout.NORTH);
		
		contentPane.add(label, BorderLayout.CENTER);
		
		// Fenster-Eigenschaften
		setResizable(false);
		setBounds(MAUDA.getRelativeBounds(285,185));
		//setBounds(100, 100, 285, 185);
		setTitle(frameTitle);
		
		setVisible(true);
		
		instance = this;
	}
	
	// Alternative Methode
	private static JWindow window;
	private static void createWindow() {
		window = new JWindow();
		JLabel label = new JLabel(ImageHandler.createImageIcon("about.png"));
		label.setBorder( BorderFactory.createRaisedBevelBorder());
		window.getContentPane().add(label, BorderLayout.CENTER);
		JButton button = new JButton("Close");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				window.dispose();
			}
		});
		window.getContentPane().add(button, BorderLayout.SOUTH);
		// Fenster zentrieren (in Abhngigkeit der Bildgre)
		Toolkit toolkit = Toolkit.getDefaultToolkit();
		Dimension scrnSize = toolkit.getScreenSize();
		Dimension labelSize = label.getPreferredSize();
		int labelWidth = labelSize.width,
				labelHeight = labelSize.height;
		window.setLocation(scrnSize.width/2 - (labelWidth/2),
											 scrnSize.height/2 - (labelHeight/2));
		// Mausklick-Schlieungs-Listener
		/*
		window.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				window.toFront();
				if(e.getButton() == MouseEvent.BUTTON3)
					window.dispose();
			}
		});*/
		window.pack();
		window.setVisible(true);		
	}
		
	/**
	 * Creates an about-frame.
	 */
	public static void createAndShowGUI() {
		//createWindow();
		// GUI nur neu erstellen, wenn es noch nicht offen ist
		if(instance == null) new AboutFrame();
		else instance.toFront();
	}
	
	/**
	 * Creates an about-frame.
	 * @param args nothing
	 */
	public static void main(String[] args) {
		new AboutFrame();
	}
}
