/*
 * Created on 10.12.2003 21:32:00
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda;

import mauda.utils.Prop;

/**
 * Holds the different difficulties and maps them to strings 
 * and vice versa.
 * 
 * @author Markus Krebs
 */
public class Difficulties {
	public static final int UNKNOWN = -1;
	public static final int EASY = 0;
	public static final int MEDIUM = 1;
	public static final int HARD = 2;
	public static final int DIFFICULTY_LEVELS = 3;
	
	/**
	 * Converts a specific difficulty to string-representation,
	 * that can be stored in an xml-file
	 * @param d id of the difficulty
	 * @return a string-representation of the difficulty
	 */
	public static String getString(int d) {
		switch(d) {
			case EASY	: return "EASY";
			case MEDIUM	: return "MEDIUM";
			case HARD	: return "HARD";
		}
		return "unknown";		
	}
	
	/**
	 * Converts a string-representation of a difficulty to its id
	 * @param s string-representation of the difficulty
	 * @return id of the difficulty
	 */
	public static int getID(String s) {
		int d = UNKNOWN;
		if(s.equals("EASY")) d = EASY;
		if(s.equals("MEDIUM")) d = MEDIUM;
		if(s.equals("HARD")) d = HARD;
		return d;
	}
	/**
	 * Converts a difficulty-id to a string-representation which
	 * can be used in a GUI, e.g. menus or buttons
	 * @param d id of the difficulty
	 * @return string-representation
	 */
	public static String getGUIString(int d) {
		switch(d) {
			case Difficulties.EASY	: return Prop.get(new Difficulties(), "Difficulty-Easy");
			case Difficulties.MEDIUM	: return Prop.get(new Difficulties(), "Difficulty-Medium");
			case Difficulties.HARD	: return Prop.get(new Difficulties(), "Difficulty-Hard");
		}
		return "unknown";
	}	
}
