/*
 * Created on 15.12.2003 18:13:59
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda;

/**
 * The listener interface for receiving exercise events.
 * 
 * The class that is interested in processing an exercise-event 
 * implements this interface, and the object created with that 
 * class is registered with a component, using the Exercise's 
 * <code>addExerciseUpdateListener</code> method. When the exercise
 * event occurs, that object's <code>exerciseUpdate</code> method
 * is invoked.
 * 
 * @author Markus Krebs
 */
public interface ExerciseUpdateListener {
	/**
	 * Invoked when an Event occures
	 * 
	 * @param e The event
	 */
	public void exerciseUpdate(ExerciseUpdateEvent e);
}
