/*
 * Created on 13.03.2004 14:41:18
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * Frame for displaying the current progess of playing.
 * 
 * @author Markus Krebs
 */
public class JedasPanelProgress extends JFrame implements ActionListener {
	
	private final String frameTitle = "Playing...";

	private Timer timer;
	private JProgressBar progressBar;

	public static int maxValue;
	public static int actValue;
	
	/**
	 * Creates a JedasPanelProgress-Frame
	 */
	public JedasPanelProgress() {
		super();

		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

		Container contentPane = getContentPane();
		contentPane.setLayout(new BorderLayout());
		
		progressBar = new JProgressBar(0, maxValue);
		progressBar.setValue(0);
		progressBar.setStringPainted(true);
		
		//contentPane.add(new JLabel("Playing..."), BorderLayout.NORTH);
		contentPane.add(progressBar, BorderLayout.CENTER);
		
		setBounds(MAUDA.getRelativeBounds(250,100));
		//setBounds(150, 150, 250, 100);
		setTitle(frameTitle);
		setVisible(true);

		int delay = 500; //milliseconds

		timer = new Timer(delay, this);
		timer.start();
	}
	
	/**
	 * Closes the progress-frame
	 */
	public static void close() {
		actValue = Integer.MAX_VALUE;
	}
	
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		//System.out.print("*");
		if(actValue>maxValue) {
			timer.stop();
			dispose();
		}
		progressBar.setValue(actValue);
		// % im Fenstertitel anzeigen
		int percent = (int)(progressBar.getPercentComplete()*100.0);
		setTitle(frameTitle+" "+percent+"%");
		//toFront();	// always on top		
	}
}
