/*
 * Created on 22.11.2004 14:27:06
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda;

import javax.swing.JFrame;
import java.awt.Rectangle;
/**
 * Stores global values.<br>At the moment only a reference to the main application frame, and
 * a bounds-calculator for new windows that should lie relative to the main frame.
 * 
 * @author Markus Krebs
 */
public class MAUDA {
	
	private static JFrame applicationMainFrame = null;
	
	/**
	 * Sets the main application frame. This is necessary to give new opened windows a
	 * reference to the main window (e.g. JOptionPane should achieve a reference)
	 * @param frame main application frame
	 */
	public static void setApplicationMainFrame(JFrame frame) {
		applicationMainFrame = frame;
	}
	
	/**
	 * Gets the main application frame. Mostly used within JOptionPane.
	 * @return main application frame
	 */
	public static JFrame getApplicationMainFrame() { 
		return applicationMainFrame;
	}
	
	/**
	 * Returns a Rectangle-Object which contains the bounds of a newly to open window. This
	 * new window will be relative to the main-window positioned.<br>
	 * This method needs the width and height of the new window, that should be opened. Then
	 * the positioning values x and y are calculated, so that the new window-bounds lies
	 * in the center of then main application frame. So the typical use is:<br>
	 * <code>frame.setBounds(MAUDA.getRelativeBounds(300,100));</code>
	 * @param w The width of the new window
	 * @param h The height of the new window
	 * @return The Bounds of the new window
	 */
	public static Rectangle getRelativeBounds(int w, int h) {
		if(applicationMainFrame == null) return new Rectangle(0,0,w,h);
		int x = applicationMainFrame.getWidth()/2-w/2+applicationMainFrame.getX();
		int y = applicationMainFrame.getHeight()/2-h/2+applicationMainFrame.getY();
		if(x<0) x=0;
		if(y<0) y=0;
		return new Rectangle(x,y,w,h);
	}
}
