/*
 * Created on 05.09.2004 16:00:04
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */

package mauda.evaluation;

import java.awt.BorderLayout;
import java.awt.Container;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.WindowConstants;
import java.awt.event.*;

/**
 * Displays a Please-Wait-Frame
 * 
 * @author Markus Krebs
 */
public class PleaseWaitFrame extends JFrame implements ActionListener {
	
	private Timer timer;

	private JLabel label;
	
	private boolean closeWin;

	/**
	 * Creates an Please-Wait-Frame
	 */
	public PleaseWaitFrame() {
		super("Please wait...");
		setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		Container contentPane = getContentPane();
		contentPane.setLayout(new BorderLayout());
		label = new JLabel("loading animation...");
		contentPane.add(label, BorderLayout.CENTER);
		setBounds(mauda.MAUDA.getRelativeBounds(250,80));
		//setBounds(100,100,250,80);
		setVisible(true);
		
		closeWin = false;
		
		//timer = new Timer(500, this);
		//timer.start();
		
	}
	
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(closeWin) {
			timer.stop();
			dispose();
		}
		label.setText("loading animation...");
		System.out.println("  updating..");
	}
	
	/**
	 * Closes the Please-Wait-Frame
	 */
	public void close() {
		//closeWin = true;
		dispose();
	}
}
