package mauda.evaluation;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
/**
 * This panel allowes switching between wrap-on or off.
 *
 * @author have no idea (found this class in Java-Developer-Forum) 
 */
public class WrapPanel extends JPanel {
	private boolean wrap = true;
	/**
	 * Creates a panel whos wrap-state can be changed
	 * @param textComponent
	 * @param wrap true = wrap on, false wrap off
	 */
	public WrapPanel(JTextComponent textComponent, boolean wrap) {
		super(new BorderLayout());
		this.wrap = wrap;
		add(textComponent, "Center");
	}
	/**
	 * Returns in wrap-on-mode -1
	 * @return -1 if wrap on; correct size when wrap is off
	 */
	public Dimension getPreferredSize() {
		Dimension d = super.getPreferredSize();
		if (wrap) d.width = 1;
		return d;
	}
	/**
	 * Sets the wrap state
	 * @param wrap true = on, false = off
	 */
	public void setWrap(boolean wrap) {
		this.wrap = wrap;
		Container con = getParent();
		if (con == null) return;
		con.invalidate();
		con.validate();
	}
	/**
	 * Gets the wrap-state
	 * @return true if wrap on; false otherwise
	 */
	public boolean getWrap() {
		return wrap;
	}
}//CLASS

/*...
JTextPane textPane = new JTextPane();
WrapPanel panel = new WrapPanel(textPane, false);
getContentPane().add(new JScrollPane(panel), "Center");
...*/

