/*
 * Created on 10.03.2004 13:24:59
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.feedback;

import mauda.plugin.Ratings;
import mauda.SimpleExercise;
import mauda.OperationRecorder;

import java.util.*;

/**
 * Evaluator-base-class for automatic evaluation of exercises
 * 
 * @author Markus Krebs
 */
public class Evaluator {

	// Rating des Op-Templates
	protected static final int templateRating = 1;

	// Ratings der SubOperatioen
	protected Ratings ratings;

	protected double maxPoints;	// Maximal erreichbare Punkte
	protected double errorPoints;	// Punkte der Fehler
	protected int errorCounter;	// #Gemachter Fehler
	
	protected double percent;

	/**
	 * Creates an Evaluator 
	 */
	public Evaluator() {
		super();
		// Ratings eintragen
		ratings = SimpleExercise.getOperationExecuter().getRatings();

		maxPoints = 0.0;
		errorPoints = 0.0;
		errorCounter = 0;
	}
	/**
	 * Gets the reached score in points of hundred (x of 100)
	 * @return Score-string
	 */
	public String getScoreString() {
		return percent+" of 100";
	}
	/**
	 * An exercise-mode like FaultMode needs to configurate some
	 * values after loading of the exercise, and this is done
	 * in this method.
	 * @param v Vector of the exercise-todo-operations
	 * @see mauda.feedback.FaultEvaluator#postProcessing(Vector)
	 */
	public void postProcessing(Vector v) { }
	/**
	 * Evaluates a total processed exercise 
	 * @param or OperationRecorder
	 */
	public void evaluate(OperationRecorder or) { }
	/**
	 * Logs an FeedbackObject the evaluator needs to evaluate a
	 * processed exercise. Mostly this is a FeedbackObject, which
	 * contains an <i>error</i> that was made.
	 * @param fo FeedbackObject
	 */
	public void log(FeedbackObject fo) { }
	/**
	 * Logs specific states that are reached by the
	 * student in FaultMode.
	 * E.g.: False chosen type of failure
	 * @param id FaultEvaluator-ID
	 * @see mauda.feedback.FaultEvaluator#SEARCH_FAILURE
	 * @see mauda.feedback.FaultEvaluator#FIRST_FAILURE_FOUND
	 * @see mauda.feedback.FaultEvaluator#FALSE_CORRECT
	 * @see mauda.feedback.FaultEvaluator#FALSE_NOT_FIRST
	 * @see mauda.feedback.FaultEvaluator#FALSE_FAILURE_TYPE_SELECTED
	 * @see mauda.feedback.FaultEvaluator#CORRECT_MODE
	 */
	public void log(int id) { }
	
	/**
	 * Gets a string-html-representation of the errors made, with
	 * diverse statistics.
	 * @return string-html-represenation of the errors made
	 */
	public String getHTMLMessage() {
		return "";
	}
	
	
	// double auf 1 Nachkommastelle runden
	protected double doubleRound(double d) {
		return ((double)((int)Math.round(d*10)))/10;
	}
	
	// Vector aus Feedback-Objekten fr Speicherung konvertieren
	protected Vector saveFeedbackObjects(Vector inv) {
		Vector v = new Vector();
		Enumeration en = inv.elements();
		while(en.hasMoreElements()) {
			FeedbackObject fo = (FeedbackObject)en.nextElement();
			v.add(fo.save());
		}
		return v;		
	}
	// Feedback-Objekt-Lade-Routine
	protected Vector loadFeedbackObjects(Vector inv) {
		Vector v = new Vector();
		Enumeration en = inv.elements();
		while(en.hasMoreElements()) {
			FeedbackObject fo = new FeedbackObject();
			fo.load((HashMap)en.nextElement());
			v.add(fo);
		}
		return v;				
	}
	
	/**
	 * Converts the results of the evaluator in a
	 * HashMap-representation for saving-purposes.
	 * @return HashMap-representation of the results
	 */
	public HashMap save() {
		return null;
	}
	/**
	 * Loads this evaluator from a HashMap-representation, that was
	 * readed from a xml-file. 
	 * @param v HashMap-representation of the results
	 */
	public void load(HashMap v) {
	}
}
