/*
 * Created on 31.01.2004 14:34:52
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.feedback;

import java.util.*;

/**
 * Storage of one element from the feedback-knowledge-base.
 * 
 * @author Markus Krebs
 */
public class FeedbackKBObject {
	
	/**
	 * Defines that the state of the object describes a correct operation
	 */
	public static final int CORRECT = 0;
	/**
	 * Defines that the state of the object describes a incorrect operation
	 */
	public static final int INCORRECT = 1;
	/**
	 * Defines that the state of the object describes a operation which
	 * correctness is undefined.
	 */
	public static final int DONTMATTER = 2;

	private String formula;
	private Vector messages;
	private int status;
	/**
	 * Creates a FeedbackKBObject
	 */
	public FeedbackKBObject() {
	}
	/**
	 * Sets the formula
	 * @param f formula
	 */
	public void setFormula(String f) { formula = f; }
	/**
	 * Sets the messages
	 * @param m Vector of messages
	 */
	public void setMessages(Vector m) { messages = (Vector)m.clone(); }

	/**
	 * Gets the formula
	 * @return formula
	 */
	public String getFormula() { return formula; }
	/**
	 * Gets the first message
	 * @return message
	 */
	public String getMessage() { return (String)messages.elementAt(0); }
	/**
	 * Gets all messages as a Vector
	 * @return vector of messages
	 */
	public Vector getMessages() { return messages; }
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		String s = "";
		s += "FORMULA: "+formula+"\n";
		Enumeration en = messages.elements();
		while(en.hasMoreElements())
			s += "MESSAGE: "+(String)en.nextElement()+"\n";
		return s;
	}

}
