/*
 * Created on 26.03.2004 11:50:04
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.feedback;

import mauda.*;
import mauda.utils.*;

import javax.swing.*;
import javax.swing.text.html.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;

/**
 * The panel for displaying feedback-messages
 * 
 * @author Markus Krebs
 */
public class FeedbackPanel extends JPanel implements HyperlinkListener, ActionListener {
	
	private FeedbackExercise exercise;

	private JPanel actionPanel;
	private GridBagLayout actionPanelGridBagLayout;
	protected JButton backButton;
	protected JButton forwardButton;
	protected JButton specialButton;
	protected JButton demandButton;
	protected JButton giveUpButton;
	
	private JTabbedPane tabbedPane;
	private HTMLView taskView;
	private HTMLView feedbackView;
	
	private HTMLEditorKit htmlEditorKit;

	/**
	 * Creates a FeedbackPanel
	 * @param exercise FeedbackExercise
	 */
	public FeedbackPanel(FeedbackExercise exercise) {
		super();
		
		this.exercise = exercise;
		
		setLayout(new BorderLayout());
				
		// TOP-Panel (oberhalb von SplitPane)
		
		JPanel topPanel = new JPanel();
		topPanel.setLayout(new BorderLayout());
		
		tabbedPane = new JTabbedPane();
		
		taskView = new HTMLView(this);
		tabbedPane.add("Task", taskView.getPanel());
		
		feedbackView = new HTMLView(this);
		tabbedPane.add("Feedback", feedbackView.getPanel());
		
		topPanel.add(tabbedPane, BorderLayout.CENTER);
		
		// ACTION-PANEL -------------
		backButton = new JButton("Back");
		backButton.addActionListener(this);
		forwardButton = new JButton("Forward");
		forwardButton.addActionListener(this);
		
		specialButton = new JButton("Special");
		specialButton.addActionListener(this);
		
		demandButton = new JButton("Demand");
		demandButton.addActionListener(this);
		
		giveUpButton = new JButton("Give up...");
		giveUpButton.addActionListener(this);

		backButton.setEnabled(false);
		forwardButton.setEnabled(false);
		specialButton.setEnabled(false);
		exercise.setInteractiveMode(Exercise.NOPOPUP);

		actionPanel = new JPanel();
		actionPanelGridBagLayout = new GridBagLayout();
		actionPanel.setLayout(actionPanelGridBagLayout);
		GridBagConstraints c = new GridBagConstraints();

		// Platzausnutzung rechts und links bzw. oben und unten falls GBL nicht alles
		// ausfllt
		c.weightx = 1.0;	// Angabe ist mir berhaupt nicht klar, aber es funktioniert
		c.weighty = 0.0;	// Auch die Java-Docu gibt da keine Angaben
		
		c.fill = GridBagConstraints.BOTH;
		c.insets = new Insets(2,2,2,2);

		c.gridwidth = 1; c.gridheight = 1;
		
		c.gridx = 0; c.gridy = 0;
		actionPanelGridBagLayout.setConstraints(backButton, c);
		actionPanel.add(backButton);
		
		c.gridx = 1;
		actionPanelGridBagLayout.setConstraints(forwardButton, c);
		actionPanel.add(forwardButton);

		// zu folgendem: siehe auch show/hideDemandButton-Methoden!		
		c.gridx = 0; c.gridy = 1; c.gridwidth = 1;
		actionPanelGridBagLayout.setConstraints(specialButton, c);
		actionPanel.add(specialButton);
		c.gridx = 1;
		actionPanelGridBagLayout.setConstraints(demandButton, c);
		actionPanel.add(demandButton);

		c.gridx = 0; c.gridy = 2; c.gridwidth = 2;
		actionPanelGridBagLayout.setConstraints(giveUpButton, c);
		actionPanel.add(giveUpButton);
		
		topPanel.add(actionPanel, BorderLayout.SOUTH);
		
		// BOTTOM-Panel (unterhalb vom SplitPane)
		
		JPanel bottomPanel = new JPanel();
		bottomPanel.setLayout(new BorderLayout());		
				
		// TreeOperationView		
		bottomPanel.add(exercise.getTreeOperationView().getPanel(), BorderLayout.CENTER);
				
		// SPLIT-Pane
		JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		splitPane.setDividerLocation(350);
		splitPane.setTopComponent(topPanel);
		splitPane.setBottomComponent(bottomPanel);
		topPanel.setMinimumSize(new Dimension(240,50));
		bottomPanel.setMinimumSize(new Dimension(240,50));
		
		// ADD TO MAIN PANEL
		
		add(splitPane, BorderLayout.CENTER);
		//setPreferredSize(new Dimension(220,50));
	}
	
	protected JTabbedPane getTabbedPane() { return tabbedPane; }
	protected HTMLView getTaskView() { return taskView; }
	protected HTMLView getFeedbackView() { return feedbackView; }

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(!exercise.actionsAllowed()) return;
		JButton b = (JButton)e.getSource();
		mauda.feedback.SimpleFeedback fb = exercise.getFeedback();
		if(b == backButton) fb.backPressed();
		else if(b == forwardButton) fb.forwardPressed();
		else if(b == specialButton) fb.specialPressed();
		else if(b == demandButton) fb.demandPressed();
		else if(b == giveUpButton) fb.giveUpPressed();
	}
	/* (non-Javadoc)
	 * @see javax.swing.event.HyperlinkListener#hyperlinkUpdate(javax.swing.event.HyperlinkEvent)
	 */
	public void hyperlinkUpdate(HyperlinkEvent e) {
		if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
			JEditorPane pane = (JEditorPane) e.getSource();
			if (e instanceof HTMLFrameHyperlinkEvent) {
				HTMLFrameHyperlinkEvent  evt = (HTMLFrameHyperlinkEvent)e;
				HTMLDocument doc = (HTMLDocument)pane.getDocument();
				doc.processHTMLFrameHyperlinkEvent(evt);
			} else {
				String href = e.getDescription();
				exercise.getFeedback().linkClicked(href);
			}
		}
	}
	
	/**
	 * Shows the demand-button in the feedback-panel
	 */
	// nderungen an der Darstellung wenn DemandButton dargestellt
	// werden soll oder nicht
	public void showDemandButton() {
		actionPanel.remove(demandButton);	// zur sicherheit
		actionPanel.add(demandButton);
		// Layout neu auslegen
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.insets = new Insets(2,2,2,2);
		c.gridx = 0; c.gridy = 1; c.gridwidth = 1; c.gridheight = 1; 
		actionPanelGridBagLayout.setConstraints(specialButton, c);
		c.gridx = 1;
		actionPanelGridBagLayout.setConstraints(demandButton, c);
		actionPanel.invalidate();
		actionPanel.revalidate();
	}
	/**
	 * Hides the demand-button in the feedback-panel
	 */
	public void hideDemandButton() {
		actionPanel.remove(demandButton);
		// Layout neu auslegen
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.insets = new Insets(2,2,2,2);
		c.gridx = 0; c.gridy = 1; c.gridwidth = 2; c.gridheight = 1;
		actionPanelGridBagLayout.setConstraints(specialButton, c);
		actionPanel.invalidate();
		actionPanel.revalidate();
	}
	
	/**
	 * Disables the back-, forward- an give-up-button.
	 */
	public void disableAllButtons() {
		backButton.setEnabled(false);
		forwardButton.setEnabled(false);
		//specialButton.setEnabled(false);
		//demandButton.setEnabled(false);
		giveUpButton.setEnabled(false);
	}
}
