/*
 * Created on 03.03.2004 17:09:53
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.feedback.select;

import java.util.*;

/**
 * Selector for chosing a specific feedback-type
 * 
 * @author Markus Krebs
 */
public class FeedbackSelector extends Selector {
	
	private static final int FB_TYPES_COUNT = 4;
	
	/**
	 * Currently no feedback-type selected
	 */
	public static final int CHOOSE = -1;
	/**
	 * Immediate Feedback & Error correction
	 */
	public static final int IFAEC = 0;
	/**
	 * Error-Flagging
	 */
	public static final int ERROR_FLAGGING = 1;
	/**
	 * Feedback on demand
	 */
	public static final int DEMAND_FEEDBACK = 2;
	/**
	 * NoTutor (no feedback)
	 */
	public static final int NO_TUTOR = 3;
	
	/**
	 * Fault-Feedback. This type can't be chosen because the
	 * feedback for FaultMode-exercises is uniquliy defined.
	 */
	// Folgender Type wird nur zur Identifizierung bei
	// FaultFeedback.java bentigt. In die Auswahl kommt dieser
	// Typ natrlich nicht, da er sofort bei Fault-Mode-Aufgaben
	// genommen wird
	public static final int FAULT_FEEDBACK = 4;
	
	
	/**
	 * Creates a FeedbackSelector
	 */
	public FeedbackSelector() {
		super();
				
		// Verfgbare Feedback Typen
		// Achtung: Reihenfolge muss der oberen final-Variablen
		// entsprechen
		Vector v = new Vector();
		for(int i=0; i<FB_TYPES_COUNT; i++)
			v.add(getFeedbackTypeNameFromID(i));
		
		setTitle("Feedback-Type:");
		createView(v);
		
	}
	/**
	 * Gets the selected Feedback-Type
	 * @return Feedback-Type-ID
	 */
	public int getFeedbackType() {
		return getSelectedIndex();
	}
	
	/**
	 * Converts a feedback-ID in a feedback-type-string
	 * @param id feedback-type-ID
	 * @return feedback-type-string
	 */
	public static String getFeedbackTypeNameFromID(int id) {
		String s = "";
		switch(id) {
			case IFAEC : s = "Immediate Feedback & Error Correction"; break;
			case ERROR_FLAGGING : s = "Error Flagging"; break;
			case DEMAND_FEEDBACK : s = "Demand Feedback"; break;
			case NO_TUTOR : s = "No Tutor (Free Mode)"; break;
			case FAULT_FEEDBACK : s = "Fault Feedback"; break; 
		}
		return s;
	}
	/**
	 * Converts a feedback-type-string in a feedback-type-ID
	 * @param s feedback-type-string
	 * @return feedback-type-ID
	 */
	public static int getIDFromFeedbackTypeName(String s) {
		if(s.equals("Immediate Feedback & Error Correction")) return IFAEC;
		if(s.equals("Error Flagging")) return ERROR_FLAGGING;
		if(s.equals("Demand Feedback")) return DEMAND_FEEDBACK;
		if(s.equals("No Tutor (Free Mode)")) return NO_TUTOR;
		if(s.equals("Fault Feedback")) return FAULT_FEEDBACK;
		return -1;
	}
	
}
