/*
 * Created on 25.03.2004 20:40:50
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.feedback.select;

import java.util.Vector;
import mauda.plugin.PlugInHandler;
/**
 * Selector for chosing a specific available plug-in
 * 
 * @author Markus Krebs
 */
public class PlugInSelector extends Selector {

	private Vector pluginID;
	/**
	 * Creates a PlugIn-Selector
	 * @param pih PlugInHandler
	 */
	public PlugInSelector(PlugInHandler pih) {
		super();

		pluginID = new Vector();

		Vector v = new Vector();
		String[] pinames = pih.getAvailablePlugIns();
		for(int i=0; i<pinames.length; i++) {
			pluginID.add(pinames[i]);
			v.add(pih.getPlugInString(pinames[i]));
		}
			
		setTitle("Type:");
		createView(v);
	}
	/**
	 * Gets the selected plug-in
	 * @return plug-in-name
	 */
	public String getPlugInName() {
		int a = getSelectedIndex();
		return (String)pluginID.elementAt(a);
	}

}
