/*
 * Created on 25.03.2004 20:03:45
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.feedback.select;

import javax.swing.*;

import mauda.MAUDA;

import java.util.Vector;
import java.awt.BorderLayout;
import java.awt.*;
/**
 * The base-class for Selector'S
 * 
 * @author Markus Krebs
 */
public class Selector extends JPanel {
	
	private String title;
	
	private JRadioButton[] rbs;	// Radion Buttons

	/**
	 * Creates a Selector
	 */
	public Selector() {
		super();

		title = "Choose:";

		setLayout(new BorderLayout());
		//add(new JLabel(Prop.get(this, "OpTemplate"+addMessage)), BorderLayout.NORTH);

	}
	
	protected void setTitle(String t) {
		title = t;
	}
	
	protected void createView(Vector v) {
		JPanel mp = new JPanel();
		mp.setBorder(BorderFactory.createTitledBorder(title));
		mp.setLayout(new BorderLayout());
		
		// Panel fr den Inhalt des Titled Borders
		JPanel p = new JPanel();
		GridBagLayout gbl = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		p.setLayout(gbl);
		c.fill = GridBagConstraints.NONE;
		c.anchor = GridBagConstraints.NORTHWEST;
		c.insets = new Insets(0,0,0,0);
		c.gridx = 0;
		c.gridy = 0;
		c.gridwidth = 1;
		c.gridheight = 1;
		ButtonGroup g = new ButtonGroup();
		rbs = new JRadioButton[v.size()];
		for(int i=0; i<v.size(); i++) {
			rbs[i] = new JRadioButton(v.elementAt(i)+"");
			g.add(rbs[i]);
			p.add(rbs[i]);
			c.gridy = i; gbl.setConstraints(rbs[i], c);
		}
		rbs[0].setSelected(true);
		mp.add(p, BorderLayout.NORTH);
		
		add(mp, BorderLayout.CENTER);				
	}
	
	protected int getSelectedIndex() {
		int index = 0;
		for(int i=0; i<rbs.length; i++)
			if(rbs[i].isSelected()) { index = i; break; }
		return index;		
	}

	/**
	 * Shows a dialog for this selector
	 */
	public void showDialog() {
		JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), this);
	}

}
