/*
 * Created on 20.07.2004 13:40:46
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.jedasnew;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.Timer;

import javax.swing.JButton;
import javax.swing.JFrame;

import jedas.io.RecordPanel;

import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
//import mauda.MAUDA;

/**
 * Holds recording-specific actions.
 * The difference between the Jedas RecordFrame is, that this holds
 * also an pause-button, to suspend and resume recording.
 * 
 * @author Markus Krebs
 */
public class RecordFrame extends JFrame implements ActionListener {
	
	private Exercise exercise;
	
	private JButton pauseButton;
	private boolean pause;
	
	private Timer timer;
	private boolean highlight;
	private Color blinkColor1 = new Color(170,170,170);
	private Color blinkColor2 = new Color(255,160,160);

	/**
	 * Creates a new recording-frame.
	 */
	public RecordFrame() {
		super("Record");
		setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		
		Container contentPane = getContentPane();
		contentPane.setLayout(new BorderLayout());
		
		RecordPanel recordPanel = new RecordPanel();
		contentPane.add(recordPanel, BorderLayout.CENTER);

		pauseButton = new JButton("Pause");
		pauseButton.addActionListener(this);
		contentPane.add(pauseButton, BorderLayout.SOUTH);
		
		setBounds(0,0,133,120);
		setVisible(true);
		
		pause = false;
		
		exercise = null;
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == pauseButton) {
			pause = !pause;
			//javax.swing.JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "selected = "+pauseButton.isSelected());
			if(pause) suspendRecording();
			else resumeRecording();
		} else {
			if(timer!=null && e.getSource() == timer) {
				if(highlight) pauseButton.setBackground(blinkColor1);
				else pauseButton.setBackground(blinkColor2);
				highlight = !highlight;
			}
		}
	}
	
	/**
	 * Sets the exercise
	 * @param exercise the exercise
	 */
	public void setExercise(Exercise exercise) {
		this.exercise = exercise;
	}
	
	/**
	 * Pause recording (suspend)
	 */
	public void suspendRecording() {
		jedas.Jedas.getScheduler().suspend();
		if(exercise!=null) {
			ExerciseUpdateEvent eue = new ExerciseUpdateEvent(exercise, ExerciseUpdateEvent.SUSPEND_EXECUTION);
			exercise.sendExerciseUpdateMessages(eue);
		}
		highlight = true;
		pauseButton.setBackground(blinkColor2);
		timer = new Timer(500, this);
		timer.start();
	}
	/**
	 * Resume recording (turn from suspend to resume)
	 */
	public void resumeRecording() {
		if(exercise!=null) {
			ExerciseUpdateEvent eue = new ExerciseUpdateEvent(exercise, ExerciseUpdateEvent.RESUME_EXECUTION);
			exercise.sendExerciseUpdateMessages(eue);
		}
		if(timer!=null) timer.stop();
		pauseButton.setBackground(null);
		jedas.Jedas.getScheduler().resume();
	}
}
