/*
 * Created on 14.12.2003 18:09:18
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.operation;

import java.util.*;
/**
 * Storage of a collection of multiple sub-operations.
 * Additionally this class has several usefull methods.
 * For Example:<br>
 * - cloning<br>
 * - load<br>
 * - save<br>
 * 
 * @author Markus Krebs
 */
public class SubOperationQueue {

	private Vector operations;
	/**
	 * Creates a SubOperationQueue
	 */
	public SubOperationQueue() {
		operations = new Vector();
	}
	/**
	 * Adds a SubOperation
	 * @param operation suboperation
	 */
	public void add(SubOperation operation) {
		operations.add(operation);
	}
	/**
	 * Gets a suboperation at the specified index
	 * @param index Index
	 * @return suboperation
	 */
	public SubOperation get(int index) {
		return (SubOperation)operations.elementAt(index);
	}
	/**
	 * Gets the length of the queue
	 * @return length
	 */
	public int length() {
		return operations.size();
	}
	/**
	 * Removes a suboperation at the specified index
	 * @param index Index
	 */
	public void remove(int index) {
		operations.removeElementAt(index);
	}
	/**
	 * Converts this queue in a vector
	 * @return vector-representation
	 */
	public Vector toVector() {
		return  operations;
	}
	
	/**
	 * Clears this queue
	 */
	public void clear() {
		//operations.removeAllElements();
		operations = new Vector();
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone() {
		SubOperationQueue soq = new SubOperationQueue();
		Enumeration en = operations.elements();
		while(en.hasMoreElements()) {
			SubOperation so = (SubOperation)en.nextElement();
			soq.add((SubOperation)so.clone());
		}
		return soq;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	// in String umwandeln (fr Ausgabe)
	public String toString() {
		String s = "";
		Enumeration en = operations.elements();
		while(en.hasMoreElements()) {
			SubOperation op = (SubOperation)en.nextElement();
			s+=op+" | ";
		}
		s += "END";
		return s;
	}
	/**
	 * Converts this queue in a vector-representation for saving-
	 * purposes.
	 * @return vector-representation of this queue
	 */
	public Vector save() {
		Vector vector = new Vector();
		Enumeration en = operations.elements();
		while(en.hasMoreElements()) {
			SubOperation op = (SubOperation)en.nextElement();
			vector.add(op.save());
		}
		return vector;
	}
	/**
	 * Loads this SubOperationQueue with the values from a vector-
	 * representation readed from e.g. a xml-file.
	 * @param vector vector-representation
	 */
	public void load(Vector vector) {
		operations = new Vector();
		Enumeration en = vector.elements();
		while(en.hasMoreElements()) {
			String s = (String)en.nextElement();
			SubOperation op = new SubOperation();
			op.load(s);
			operations.add(op);
		}
	}

}
