/*
 * Created on 07.01.2004 14:26:25
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.plugin.fibheap;

//import mauda.MAUDA;
import mauda.plugin.*;
import mauda.operation.*;

import java.util.*;
/**
 * Maps operation-ids to the corresponding methods in the
 * FibHeap-data-structure.
 * 
 * @author Markus Krebs
 */
public class FibHeapOperationExecuter extends OperationExecuter {
	
	/**
	 * Creates a FibHeap-Operation-Executer
	 */
	public FibHeapOperationExecuter() {
		super();	// Muss aufgerufen werden
	}
	
	/* (non-Javadoc)
	 * @see mauda.plugin.OperationExecuter#executeTemplate(mauda.operation.Operation, java.lang.Object)
	 */
	public void executeTemplate(Operation op, Object o) {
		//javax.swing.JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "executeTemplate");
		
		//FibHeapExt fibHeapCopy = (FibHeapExt)((FibHeapExt)o).copy();
		FibHeapDSExt fibHeapCopy = (FibHeapDSExt)((FibHeapExt)o).copyDS();
		
		execute(op, fibHeapCopy);
	}
	
	/* (non-Javadoc)
	 * @see mauda.plugin.OperationExecuter#execute(mauda.operation.Operation, java.lang.Object)
	 */
	public void execute(Operation op, Object o) {
		//if(!(o instanceof FibHeapExt)) return;
		//FibHeapExt fibHeap = (FibHeapExt)o;
		FibHeapOperations fibHeap = (FibHeapOperations)o;
		FibHeapSubOperations fibHeapSub = null;
		if(o instanceof FibHeapSubOperations)
			fibHeapSub = (FibHeapSubOperations)o;
		if(fibHeapSub!=null) fibHeapSub.clearSubOperationQueue();
		String operation = op.getID();
		int param1 = op.getParameter1();
		int param2 = op.getParameter2();
		if(operation.equals("INSERT")) fibHeap.insertOp(param1);
		else if(operation.equals("DELETE")) fibHeap.deleteOp(param1);
		else if(operation.equals("DECREASE_KEY")) fibHeap.decreasekeyOp(param1,param2);
		else if(operation.equals("DELETE_MIN")) {
			int k = fibHeap.deleteminOp();
			op.setEffect(k);
		} 
		// Rating anhand der SubOperation ausrechnen
		if(fibHeapSub!=null) {
			int rating = 0;
			SubOperationQueue soq = fibHeapSub.getSubOperationQueue();
			Enumeration en = soq.toVector().elements();
			while(en.hasMoreElements()) {
				SubOperation so = (SubOperation)en.nextElement();
				rating += ((Integer)ratings.get(so.getID())).intValue();
			}
			op.setSubOperationQueue((SubOperationQueue)soq.clone());
			op.setRating(rating);
		} 
		//System.out.println(this);	// muss nach allem stehen da effect von delete-min
	}
	
	/* (non-Javadoc)
	 * @see mauda.plugin.OperationExecuter#execute(mauda.operation.SubOperation, java.lang.Object)
	 */
	public void execute(SubOperation op, Object o) {
		
		//if(!(o instanceof FibHeapExt)) return;
		//FibHeapExt fibHeap = (FibHeapExt)o;
		FibHeapSubOperations fibHeap = null;
		if(o instanceof FibHeapSubOperations) {
			fibHeap = (FibHeapSubOperations)o;
			fibHeap.clearSubOperationQueue();
		}
		else return;
		String operation = op.getID();
		int param1 = op.getParameter1();
		int param2 = op.getParameter2();
		if(operation.equals("SETKEY")) fibHeap.setKeyOp(param1,param2);
		else if(operation.equals("CUT")) fibHeap.cutOp(param1);
		else if(operation.equals("MARK")) fibHeap.markOp(param1);
		else if(operation.equals("UNMARK")) fibHeap.unmarkOp(param1);
		else if(operation.equals("NEWFHEAPMELD")) fibHeap.newFHeapMeldOp(param1);
		else if(operation.equals("LINK")) fibHeap.linkOp(param1, param2);
		else if(operation.equals("UPDATEMIN")) fibHeap.updateMinOp(param1);
		else if(operation.equals("REMOVE")) fibHeap.removeOp(param1);
		//System.out.println(this);	// muss nach allem stehen da effect von delete-min
	}
}
