/*
 * Created on 21.12.2003 15:30:39
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.plugin.fibheap;

import mauda.utils.Prop;

import java.awt.*;
import java.awt.event.*;

/**
 * Interactive-PopUpMenu when exercise in
 * Interactive-BOTHOPERATION-Mode
 * 
 * @author Markus Krebs
 */
class HeapAllOpMenu extends PopupMenu {
	// HeapOpMenu ==============================================================
	protected static final String deleteMin = "DeleteMin";
	protected static final String deleteNode = "DeleteNode";
	protected static final String randomInsert = "RandomInsert";
	protected static final String randomDecreaseKeyNode = "RandomDecreaseKeyNode";
	protected static final String insert = "Insert";
	protected static final String decreaseKeyNode = "DecreaseKeyNode";

	protected Menu     INSERT			= new Menu(Prop.get(this, "PopUp"+insert));
	protected Menu     DECREASEKEY	= new Menu(Prop.get(this, "PopUp"+decreaseKeyNode));
	protected Menu[] insMenu	= new Menu[4];
	protected Menu[] decMenu	= new Menu[4];

	// HeapSubOpMenu ==============================================================
	protected static final String cutNode = "CutNode";
	protected static final String markNode = "MarkNode";
	protected static final String unmarkNode = "UnmarkNode";
	protected static final String updateMinNode = "UpdateMinNode";
	protected static final String removeNode = "RemoveNode";
	protected static final String setKey = "SetKey";
	protected static final String newFHeapMeld = "NewFHeapMeld";
	protected static final String link = "Link";

	private Menu		SETKEY			= new Menu(Prop.get(this, "PopUp"+setKey));
	private Menu		LINK			= new Menu(Prop.get(this, "PopUp"+link));
	private Menu		NEWFHEAPMELD	= new Menu(Prop.get(this, "PopUp"+newFHeapMeld));
	private Menu[] setKeyMenu	= new Menu[4];
	private Menu[] linkMenu	= new Menu[4];
	private Menu[] newFHeapMeldMenu	= new Menu[4];
	
	
	/**
	 * Creates a new HeapAllOpMenu
	 * @param onNode true if a menu should generated which will be displayed when the user is on a node, false otherwise
	 * @param al The listener for the menu
	 */
	public HeapAllOpMenu(boolean onNode, ActionListener al) {
		super();
		
		// HeapOpMenu ==========================================================
		INSERT.add(createMenuItem(randomInsert));
		INSERT.addSeparator();
		DECREASEKEY.add(createMenuItem(randomDecreaseKeyNode));
		DECREASEKEY.addSeparator();
		for (int j=0; j<4; j++) {
			if (j==0) {
				insMenu[j] = new Menu(" 1 .. 24 ");
				decMenu[j] = new Menu(" 1 .. 24 ");
			} else {
				insMenu[j] = new Menu((j*25) +" .. "+ ((j+1)*25-1) +" ");
				decMenu[j] = new Menu((j*25) +" .. "+ ((j+1)*25-1) +" ");
			}
			INSERT.add(insMenu[j]);
			insMenu[j].addActionListener(al);
			DECREASEKEY.add(decMenu[j]);
			decMenu[j].addActionListener(al);
		}
		for (int i=1; i<100; i++) {
			insMenu[i/25].add(createNumberMenuItem(insert, i));
			decMenu[i/25].add(createNumberMenuItem(decreaseKeyNode, i));
		}
		this.addActionListener(al);
		this.DECREASEKEY.addActionListener(al);
		this.INSERT.addActionListener(al);
		// Menu aufbauen
		if (onNode) {
			add(DECREASEKEY);
			add(createMenuItem(deleteNode));
			addSeparator();
			add(INSERT);
			add(createMenuItem(deleteMin));
		} else {
			add(INSERT);
			add(createMenuItem(deleteMin));
		}
		
		// Trennlinie zwischen HeapOpMenu und HeapSubOpMenu
		addSeparator();
		addSeparator();
		
		// HeapOpSubMenu ==========================================================
		for (int j=0; j<4; j++) {
			if (j==0) {
				setKeyMenu[j]	= new Menu(" 1 .. 24 ");
				linkMenu[j]		= new Menu(" 1 .. 24 ");
				newFHeapMeldMenu[j]	= new Menu(" 1 .. 24 ");
			} else {
				setKeyMenu[j]	= new Menu((j*25) +" .. "+ ((j+1)*25-1) +" ");
				linkMenu[j]		= new Menu((j*25) +" .. "+ ((j+1)*25-1) +" ");
				newFHeapMeldMenu[j]	= new Menu((j*25) +" .. "+ ((j+1)*25-1) +" ");
			}
			SETKEY.add(setKeyMenu[j]);
			setKeyMenu[j].addActionListener(al);
			LINK.add(linkMenu[j]);
			linkMenu[j].addActionListener(al);
			NEWFHEAPMELD.add(newFHeapMeldMenu[j]);
			newFHeapMeldMenu[j].addActionListener(al);
		}
		for (int i=1; i<100; i++) {
			setKeyMenu[i/25].add(createNumberMenuItem(setKey,i));
			linkMenu[i/25].add(createNumberMenuItem(link, i));
			newFHeapMeldMenu[i/25].add(createNumberMenuItem(newFHeapMeld, i));
		}
		//this.addActionListener(al);	// Wurde oben schon erledigt (bei HeapOpMenu-Teil)
		// Menu aufbauen
		if (onNode) {
			add(createMenuItem(cutNode));
			add(createMenuItem(markNode));
			add(createMenuItem(unmarkNode));
			add(createMenuItem(updateMinNode));
			add(createMenuItem(removeNode));
			addSeparator();
			add(SETKEY);
			add(LINK);
			addSeparator();
			add(NEWFHEAPMELD);
		} else {
			add(NEWFHEAPMELD);
		}
	}
	
	// COMMON
	private MenuItem createMenuItem(String s) {
		MenuItem mi = new MenuItem(Prop.get(this, "PopUp"+s));
		mi.setActionCommand(s);
		return mi;
	}
	private MenuItem createNumberMenuItem(String command, int nr) {
		String s = Integer.toString(nr);
		MenuItem mi = new MenuItem(s);
		mi.setActionCommand(command+" "+s);
		return mi;
	}
}