/*
 * Created on 01.03.2004 18:45:12
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.treeoperationview;

import mauda.operation.*;

import javax.swing.tree.*;
import javax.swing.*;
import java.awt.*;

/**
 * A renderer of the TreeOperationView which is responsible for
 * drawing the tree. E.g.: Icons used, bold-text, etc.
 * 
 * @author Markus Krebs
 */
public class MyTreeCellRenderer extends DefaultTreeCellRenderer {
	
	private Icon folderIcon;
	private Icon folderCorrectIcon;
	private Icon folderIncorrectIcon;
	private Icon documentIcon;
	private Icon documentCorrectIcon;
	private Icon documentIncorrectIcon;
	//private Icon actIcon; 

	/**
	 * Creates a MyTreeCellRenderer
	 */
	public MyTreeCellRenderer() {
		folderIcon = createImageIcon("tree_folder.gif");
		folderCorrectIcon = createImageIcon("tree_folder_correct.gif");
		folderIncorrectIcon = createImageIcon("tree_folder_incorrect.gif");
		documentIcon = createImageIcon("tree_document.gif");
		documentCorrectIcon = createImageIcon("tree_document_correct.gif");
		documentIncorrectIcon = createImageIcon("tree_document_incorrect.gif");
		//actIcon = createImageIcon("lalala.jpg");
	}
	protected static ImageIcon createImageIcon(String path) {
		java.net.URL imgURL = MyTreeCellRenderer.class.getResource(path);
		if (imgURL != null) {
			return new ImageIcon(imgURL);
		} else {
			System.err.println("Couldn't find file: " + path);
			return null;
		}
	}
	
	/* (non-Javadoc)
	 * @see javax.swing.tree.TreeCellRenderer#getTreeCellRendererComponent(javax.swing.JTree, java.lang.Object, boolean, boolean, boolean, int, boolean)
	 */
	public Component getTreeCellRendererComponent(
						JTree tree,
						Object value,
						boolean sel,
						boolean expanded,
						boolean leaf,
						int row,
						boolean hasFocus) {

		super.getTreeCellRendererComponent(
						tree, value, sel,
						expanded, leaf, row,
						hasFocus);

		// TreeObject holen
		DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
		TreeObject to = (TreeObject)(node.getUserObject());
		SimpleOperation so = to.getOperation();	// Wurzel => null
		/*
		if (to.isActual()) {
			setIcon(actIcon);
			setToolTipText("This is the actual Operation.");
		}*/
		if(so instanceof Operation){
			Icon icon = null;
			switch(to.getCorrectness()) {
				case TreeObject.CORRECT :
					icon = folderCorrectIcon;
					break;
				case TreeObject.INCORRECT :
					icon = folderIncorrectIcon;
					break; 
				case TreeObject.UNDEFINED :
					icon = folderIcon;
					break;
			}
			setIcon(icon);
			//setToolTipText(null); //no tool tip
		} else if(so instanceof SubOperation) {
			//String s = ((SubOperation)so).getOperation();
			//s = s.toLowerCase();
			Icon icon = null;
			String ttip = null;
			switch(to.getCorrectness()) {
				case TreeObject.CORRECT :
					icon = documentCorrectIcon;
					break;
				case TreeObject.INCORRECT :
					icon = documentIncorrectIcon;
					break; 
				case TreeObject.UNDEFINED :
					icon = documentIcon;
					break;
			}
			setIcon(icon);
			//setToolTipText(ttip);
		} else {
			// Wurzelknoten
			setIcon(folderIcon);
		}

		return this;
	}

}
