/*
 * Created on 13.03.2004 15:34:18
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.treeoperationview;

import javax.swing.*;
import java.awt.event.*;

/**
 * The context-menu for the displayed Tree by TreeOperationView
 * 
 * @author Markus Krebs
 */
public class NodePopup extends JPopupMenu {

	/**
	 * ActionCommand for replay-menu-item
	 */
	public static final String play = "Replay from here";
	/**
	 * ActionCommand for jump-menu-item
	 */
	public static final String jumpTo = "Jump to here";
	
	private ActionListener actionListener;
	
	/**
	 * Creates a context-menu
	 * @param al The listener for the menu
	 */
	public NodePopup(ActionListener al) {
		super();
		actionListener = al;

		add(createMenuItem(play));
		add(createMenuItem(jumpTo));
	}
	
	private JMenuItem createMenuItem(String c) {
		JMenuItem mi = new JMenuItem(c);
		mi.setActionCommand(c);
		mi.addActionListener(actionListener);
		return mi;		
	}
	
	/**
	 * Adds a menu-item dynamically to the context-menu
	 * @param c ActionCommand
	 * @param al The listener for the menu-item
	 */
	// Ein Fremd-MenuItem hinzufgen
	public void addItem(String c, ActionListener al) {
		JMenuItem mi = new JMenuItem(c);
		mi.setActionCommand(c);
		mi.addActionListener(al);
		add(mi);
		return;				
	}
	
	/**
	 * Removes a menu-item dynamically from the context-menu
	 * @param c The ActionCommand of the menu-item to delete
	 */
	// Entfernen eines Fremd-MenuItems ber den ActionCommand
	public void removeItem(String c) {
		MenuElement[] me = getSubElements();
		for(int i=0; i<me.length; i++) {
			JMenuItem mi = (JMenuItem)me[i].getComponent();
			String ac = mi.getActionCommand();
			//System.out.println(ac);
			if(ac == c) {
				try { remove(i); }	// ACHTUNG: index (0..x)
				catch(Exception ex) {}
				//System.out.println("-> successfully removed!");
				return;				
			}
		}
	}
}
