/*
 * Created on 01.03.2004 18:46:23
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.treeoperationview;

import mauda.operation.*;

import javax.swing.tree.*;
/**
 * Stores additional information to tree-entries
 * 
 * @author Markus Krebs
 */
public class TreeObject {

	/**
	 * Correctness undefined
	 */
	public static final int UNDEFINED = 0;
	/**
	 * Correctness: correct
	 */
	public static final int CORRECT = 1;
	/**
	 * Correctness: incorrect
	 */
	public static final int INCORRECT = 2;
	
	/**
	 * Defines the initial correctness
	 */
	// Initiale Correctness wenn Konstruktor aufgerufen wird
	public static int initialCorrectness = UNDEFINED;

	private int correctness;
	
	private boolean actual = false;
	private boolean processing = false;
		
	private String text;
	private SimpleOperation simpleOperation;
	private DefaultMutableTreeNode node;
	
	private int state = NORMAL;
	
	/**
	 * Operation is a normal-operation, which means that there is
	 * no identification if it is a init- or todo-operation
	 */
	public static final int NORMAL = 0;
	/**
	 * Operation is a init-operation
	 */
	public static final int INIT = 1;
	/**
	 * Operation is a todo-operation
	 */
	public static final int TODO = 2;

	/**
	 * Creates a TreeObject
	 * @param so The associated operation
	 */
	public TreeObject(SimpleOperation so) {
		simpleOperation = so;
		//correctness = UNDEFINED;
		correctness = initialCorrectness;
	}
	/**
	 * Sets the to displayed text. This make only sense for the
	 * root-node, because the other nodes has as text the ID and
	 * parameters.
	 * @param text
	 */
	public void setText(String text) {
		// Text setzen, falls kein Operation-Objekt
		// im Moment nur fr Root-Node
		this.text = text;
	}
	/**
	 * Sets the associated TreeNode
	 * @param n TreeNode
	 */
	public void setNode(DefaultMutableTreeNode n) { node = n; }
	/**
	 * Gets the associated TreeNode
	 * @return TreeNode
	 */
	public DefaultMutableTreeNode getNode() { return node; }
	
	/**
	 * Sets the state of the TreeObject
	 * @param s state-id
	 * @see mauda.treeoperationview#NORMAL
	 * @see mauda.treeoperationview#INIT
	 * @see mauda.treeoperationview#TODO
	 */
	public void setState(int s) { state = s; }
	/**
	 * Gets the state of the TreeObject
	 * @return state-id
	 */
	public int getState() { return state; }
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		// Ausgabe im Tree
		String t = TreeOperationView.rootNodeText;
		if(simpleOperation != null){
			switch(TreeOperationView.DISPLAY_MODE) {
				case TreeOperationView.NORMAL_DISPLAY_MODE :
					t = simpleOperation.out();
					break;
				case TreeOperationView.GENERATION_DISPLAY_MODE :
					t = simpleOperation+"";
					break;
			}
		}
		switch(state) {
			case NORMAL :
				if(isActual()) t = "<html><b>"+t+"</b></html>";
				else if(isProcessing()) t = "<html><b><i>"+t+"</i></b></html>";
				//else t = t;
				break;
			case INIT :
				if(isActual()) t = "<html><b color=#66aa66>"+t+"</b></html>";
				else if(isProcessing()) t = "<html><b color=#66aa66><i>"+t+"</i></b></html>";
				else t = "<html><font color=#66aa66>"+t+"</font></html>";
				break;
			case TODO :
				if(isActual()) t = "<html><b color=#000000>"+t+"</b></html>";
				else if(isProcessing()) t = "<html><b color=#000000><i>"+t+"</i></b></html>";
				else t = "<html><font color=#000000>"+t+"</font></html>";
				break; 
		}
		/*
		if(simpleOperation instanceof Operation) {
			switch(correctness) {
				case INCORRECT: t = t+" (incorrect)"; break;
				case CORRECT: t = t+" (correct)"; break;
				case UNDEFINED: t = t+" (undefined)"; break;				
			}
		}*/
		return t;
	}
	
	/**
	 * Gets the operation
	 * @return operation
	 */
	public SimpleOperation getOperation() {
		// Operation zurckgeben
		return simpleOperation;
	}
	/**
	 * Sets if this node is the actual node, or not. A node that is
	 * actual will be marked with bold-text
	 * @param b true if this is the actual node, false otherwise
	 */
	// Aktuelle Operation
	// darf natrlich nur fr ein Objekt des Trees wahr sein
	public void setActual(boolean b) { actual = b; }
	
	/**
	 * Test if this node is actual
	 * @return true if the node is the actual node, false otherwise
	 */
	public boolean isActual() { return actual; }
	
	/**
	 * Sets if this node is the actual processed node, or not. A node that is
	 * in process will be marked with bold-italic-text
	 * @param b true if this is the actual node, false otherwise
	 */
	public void setProcessing(boolean b) { processing = b; }
	
	/**
	 * Test if this node is processed
	 * @return true if the node is the process node, false otherwise
	 */
	public boolean isProcessing() { return processing; }
	
	/**
	 * Sets the correctness
	 * @param c correctness-ID
	 * @see mauda.treeoperationview#CORRECT
	 * @see mauda.treeoperationview#INCORRECT
	 * @see mauda.treeoperationview#UNDEFINED
	 */
	public void setCorrectness(int c) { correctness = c; }
	/**
	 * Gets the correctness
	 * @return correctness-ID
	 */
	public int getCorrectness() { return correctness; }
}
