/*
 * Created on 25.02.2004 11:40:36
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.utils;

import java.util.*;
import java.io.*;
/**
 * The central class to handle text-/image-properties of buttons,
 * menu-items, etc.
 * 
 * @author Markus Krebs
 */
public class Prop {

	private static String language = "eng";

	private static HashMap loadedProperties = new HashMap();
	
	/**
	 * Gets a property-string from the given location.<br>
	 * Internally there must be a property-file named
	 * "properties_eng" in every package. Thru the delivered
	 * source-class (1st parameter) its possible to locate the
	 * corresponding property-file.
	 * @param o The class from which this get-method was called
	 * @param s The key of the property
	 * @return The value of the property
	 */
	public static String get(Object o, String s) {
		//System.out.println("Prop-call: "+o+" --- "+s);
		Properties p = null;
		Object po = loadedProperties.get(o);
		if(po == null) {
			p = load(o);
			loadedProperties.put(o, p);
		} else p = (Properties)po;
		return p.getProperty(s);
	}
	
	/**
	 * Loads a specific property-file from the given location
	 * (class inside a specific package).
	 * @param o The class from which this load-method (get-method)
	 * was called.
	 * @return Properties
	 */
	public static Properties load(Object o) {
		Properties properties = new Properties();
		try {
			// Im Nachfolgenden: Irgendeine Klasse in "generation" angeben
			// --> Habe GenEditor gewhlt
			Class c = o.getClass();
			InputStream is = c.getResourceAsStream("properties_"+language);
			properties.load(is);

		} catch(Exception ex) {
			System.err.println("Error while loading PlugIn-Properties!");
			ex.printStackTrace();
			System.exit(0); 
		}
		return properties;
	}
	
}
