/*
 * Created on 26.05.2004 19:52:29
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package test;

import jedas.*;
import jedas.io.Recorder;

import mauda.plugin.fibheap.*;

/**
 * Description
 * 
 * @author Markus Krebs
 */
public class RecordTest implements JedasApplication {

	Scheduler scheduler;
	CompPanel compPanel;

	public RecordTest() {
		// create a new scheduler
		scheduler = new Scheduler();
		// create a frame for this animation with all extras
		JedasFrame jf = new JedasFrame( this, scheduler, "FibHeap demo", JedasFrame.ALL );
		// retrieve the frame's CompPanel instance	
		compPanel = jf.getCompPanel();
		// we want a grid
		compPanel.setGridSize( new DPair( .1, .1 ) );
		initJedas();

		Recorder recorder = Jedas.getRecorder();
		Recorder.setFileName("fibheapdemo.jea");
	}

	public static void main(String[] args) {
		new RecordTest();
	}
	
	public void initJedas() {
		compPanel.clear();
		//compPanel.addItem( pie );
		// update the panel display to reflect the added items
		Jedas.updateDisplay();
	}
	public void run() {
		FibHeapExt fibheap = new FibHeapExt();
		compPanel.addItem(fibheap.getMainCompObj());
		fibheap.insertOp(4);	
		fibheap.insertOp(7);	
		fibheap.insertOp(14);	
		fibheap.insertOp(1);	
		fibheap.insertOp(25);	
		fibheap.insertOp(3);	
		fibheap.insertOp(13);
		fibheap.deleteminOp();
		fibheap.decreasekeyOp(25,2);
		fibheap.deleteOp(14);	
		scheduler.start();
	}
}
