/*
 * Created on 09.02.2004 22:02:07
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package work;

import mauda.utils.Prop;
import mauda.images.ImageHandler;

import javax.swing.*;

import java.awt.event.*;

/**
 * Generates the top-toolbar for work-editor
 * 
 * @author Markus Krebs
 */
public class TopToolBar extends JToolBar {
	
	private ActionListener actionListener;

	/**
	 * Creates the TopToolBar
	 * @param al The listener for the toolbar
	 */
	public TopToolBar(ActionListener al) {
		super();
		
		actionListener = al;
		
		createButton(ActionCommands.newFile);
		createButton(ActionCommands.newAutoFile);
		createButton(ActionCommands.openFile);
		createButton(ActionCommands.saveFile);
		createButton(ActionCommands.saveAsFile);
		createButton(ActionCommands.meta);
		addSeparator();
		createButton(ActionCommands.switchFeedback);
		if(ActionCommands.showReloadKBButton) {
			addSeparator();
			createButton(ActionCommands.reloadKB);
		}

		addSeparator();
		
		// WorkEditor: Undo/Redo (ENTFERNEN?, dann nur hier -> reicht aus)
		createButton(ActionCommands.undo);
		createButton(ActionCommands.redo);
		addSeparator();
		
		createButton(ActionCommands.showHelp);

	}
	// Button hinzufgen
	protected JButton createButton(String text) {
		String buttonText = Prop.get(this,text);
		String imgfname = Prop.get(this, text+"Image");
		JButton button = null;
		if(imgfname.equals("NONE")) {
			button = new JButton(buttonText);
		} else {
			ImageIcon ii = ImageHandler.createImageIcon(imgfname);
			//button = new JButton(new ImageIcon("images/"+imgfname));
			button = new JButton(ii);
			button.setMargin(new java.awt.Insets(2,2,2,2));
			button.setToolTipText(buttonText);
		}
		button.addActionListener(actionListener);
		button.setActionCommand(text);
		add(button);
		return button;
	}
}
