/*
 * Created on 11.01.2004 15:53:10
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package work;

import mauda.utils.Prop;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * MenuBar for the generation-editor
 * 
 * @author Markus Krebs
 */
public class WorkMenu extends MenuBar {
	
	private EventListener actionListener;

	private Menu file = new Menu(Prop.get(this, "File"));
	private Menu info = new Menu(Prop.get(this, "Information"));
	/**
	 * Creates the menu for Work-Editor
	 * @param al The listener for the menu
	 */
	public WorkMenu(EventListener al) {
		super();
		
		actionListener = al;
		
		addMI(file, ActionCommands.newFile);
		addMI(file, ActionCommands.newAutoFile);
		addMI(file, ActionCommands.openFile);
		addMI(file, ActionCommands.saveFile);
		addMI(file, ActionCommands.saveAsFile);
		addMI(file, ActionCommands.meta);
		file.addSeparator();
		addMI(file, ActionCommands.switchFeedback);
		file.addSeparator();
		addMI(file, ActionCommands.exit);
		
		add(file);

		addMI(info, ActionCommands.showAbout);
		addMI(info, ActionCommands.showHelp);
		add(info);
	}
	// Normales MenuItem hinzufgen
	private void addMI(Menu m, String text) {
		String label = Prop.get(this, text);
		MenuItem mi = new MenuItem(label);
		mi.addActionListener((ActionListener)actionListener);
		mi.setActionCommand(text);
		m.add(mi);
	}
}
