/*
 * Created on 09.02.2004 21:55:06
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package evalplayer;

import mauda.*;
import mauda.utils.*;
import mauda.evaluation.*;
import help.*;

//import jedas.io.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.beans.*;
import java.util.*;


/**
 * The listener for menu- and toolbar-actions
 * 
 * @author Markus Krebs
 */
public class MenuToolBarListener implements ActionListener {

	private PlayerExercise exercise;

	private JFileChooser fileChooser;
	private PreviewPanel previewPanel = new PreviewPanel();
	
	/**
	 * The Listener for menu- and toolbar-actions
	 * @param exercise PlayerExercise
	 */
	public MenuToolBarListener(PlayerExercise exercise) {
		this.exercise = exercise;
		fileChooser = new JFileChooser(FileLocation.evaluatedPath);
		fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		fileChooser.addChoosableFileFilter(new XMLFilter());
		fileChooser.setMultiSelectionEnabled(false); // Mehrfachselektion AUS
		fileChooser.setAccessory(previewPanel);
		fileChooser.addPropertyChangeListener(new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent e) {
				if(e.getPropertyName().equals(
									 JFileChooser.SELECTED_FILE_CHANGED_PROPERTY)) {
					File f = (File)e.getNewValue();
					if(f==null) return;
					String s = f.getPath(), suffix = null;
					int i = s.lastIndexOf('.');

					if(i > 0 && i < s.length() - 1)
						suffix = s.substring(i+1).toLowerCase();

					if(suffix!=null&&suffix.equals("xml"))
						previewPanel.configure(f);
				}
			}
		});
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(!exercise.actionsAllowed()) return;
		String s = e.getActionCommand();
		//System.out.println("ActionCommand: "+s);
		if(s == ActionCommands.openFile) {
			MetaData.setDisplayMode(MetaData.EDITOR);
			fileChooser.setCurrentDirectory(new File(FileLocation.evaluatedPath));
			openFile();
		} else if(s == ActionCommands.meta) {
			boolean mod = exercise.getMetaData().inputDialog();
			if(mod) JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Changings in Meta-Data will not be saved!");
		} else if(s == ActionCommands.exit) {
			System.exit(0);
		} else if(s == ActionCommands.showAbout) {
			AboutFrame.createAndShowGUI();
		} else if(s == ActionCommands.showHelp) {
			HelpTree.setView(HelpTree.EVALPLAYER_VIEW);
			HelpFrame.createAndShowGUI();
		}
	}
	/**
	 * Opens a file by showing an filechooser, and then calls
	 * <code>openFile(File)</code>
	 * @see evalplayer.MenuToolBarListener#openFile(File)
	 */
	private void openFile() {
		int state = fileChooser.showOpenDialog(null);
		if(state == JFileChooser.APPROVE_OPTION) {
			File file = fileChooser.getSelectedFile();
			if(file.isFile()) {
				openFile(file);				
			}
		}
	}

	/**
	 * Opens the specified file
	 * @param file The file-Object
	 */
	private void openFile(File file) {
		
		//JedasPlayer jedasPlayer = JedasPlayer.getInstance();
		//new jedas.io.JedasPlayer(file.getAbsolutePath());
		
		exercise.setFilename(file.getAbsolutePath());
		
		HashMap hm = exercise.load(exercise.getFilename());
		if(hm==null) return;	// <-- Sollte nie vorkommen (falls PlugIn nicht existiert)
		
		String editorState = exercise.getMetaData().getEditorState();
		String evaluatorState = exercise.getMetaData().getEvaluatorState();
		String evaluatorName = exercise.getMetaData().getEvaluatorName();
		
		if(!evaluatorState.equals("evaluated")) {
			JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant load a not evaluated exercises!");
			return;
		}
		if(evaluatorName.equals("AutoEvaluator")) {
			JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant load a automatically evaluated exercise!");
			return;
		}

		exercise.loadEvaluated(hm);
		
		return;
	}
}
