/*
 * Created on 25.06.2004 12:35:03
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package evalplayer;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;


/**
 * Handles the speed of an animation by providing a slider to set the speed.
 * 
 * @author Markus Krebs
 */
public class SpeedSlider implements ChangeListener {
	private final String labelText = " Anim-Speed: ";
	
	private int hpercentAnimStepTime = 30;	// 100%-Geschwindigkeit
	private int hpercent = 30;	// 100% Marke beim Slider (Echtzeit)
	private int max = 100;		// hchster Wert
	
	private JPanel panel;
	private JLabel label;
	private JSlider slider;
	/**
	 * Creates a SpeedSlider
	 */
	public SpeedSlider() {
		super();
		
		hpercentAnimStepTime *= (int)mauda.evaluation.TimeStampRecorder.timeExtend;
		hpercent *= (int)mauda.evaluation.TimeStampRecorder.timeExtend;
		max *= (int)mauda.evaluation.TimeStampRecorder.timeExtend;		
		
		panel = new JPanel();
		panel.setLayout(new BorderLayout());
		label = new JLabel(labelText);
		int slmax = max;
		int slcur = hpercent;
		slider = new JSlider(0, slmax, slcur);	// New Slider: 0-slmax aktueller Wert: slcur
		panel.add(label, BorderLayout.NORTH);
		panel.add(slider, BorderLayout.CENTER);
		slider.addChangeListener(this);
		//slider.setMajorTickSpacing(100);
		//slider.setMinorTickSpacing(10);
		//slider.setPaintTicks(true);
		updateSpeed();
	}
	/* (non-Javadoc)
	 * @see javax.swing.event.ChangeListener#stateChanged(javax.swing.event.ChangeEvent)
	 */
	public void stateChanged(ChangeEvent e) {
		updateSpeed();
	}
	/**
	 * Returns a panel that contains a slider to control the speed.
	 * @return A panel containing a slider
	 */
	public JPanel getPanel() { return panel; }
	
	private void updateSpeed() {
		int v = slider.getValue();
		
		/*
		//label.setText(labelText+v);
		//OperationPlayerThread.animStepTime = v;

		long stepTime = (long)(Math.pow(((double)v/(double)mauda.evaluation.TimeStampRecorder.timeExtend)/5, 2));
		stepTime *= (int)mauda.evaluation.TimeStampRecorder.timeExtend;
		OperationPlayerThread.animStepTime = stepTime;
		*/
		
		long percent = 0;
		if(v==0) percent = 0;
		else if(v<hpercent) percent = (long)(((double)v/(double)hpercent)*(double)100);
		else if(v==hpercent) percent = 100;
		else if(v>hpercent) percent = (long)Math.pow((v-hpercent)/(double)mauda.evaluation.TimeStampRecorder.timeExtend/2.0, 2)+100;
		
		OperationPlayerThread.animStepTime = (long)(hpercentAnimStepTime*((double)percent/100));
		
		label.setText(labelText+""+percent);
		
	}
}
