/*
 * Created on 09.02.2004 22:02:07
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package evalplayer;

import mauda.utils.Prop;
import mauda.images.ImageHandler;

import javax.swing.*;
import java.awt.event.*;

/**
 * Generates the top-toolbar
 * 
 * @author Markus Krebs
 */
public class TopToolBar extends JToolBar {

	private ActionListener actionListener;

	/**
	 * Creates the toolbar
	 * @param al The listener for actions
	 */
	public TopToolBar(ActionListener al) {
		super();
		
		actionListener = al;
		
		createButton(ActionCommands.openFile);
		createButton(ActionCommands.meta);
		
		addSeparator();
		
		createButton(ActionCommands.showHelp);
		
	}
	/**
	 * Adds a button to the toolbar
	 * @param text The ActionCommand of the button
	 * @return Returns the JButton that was created
	 * @see evalplayer.ActionCommands
	 */
	protected JButton createButton(String text) {
		String buttonText = Prop.get(this,text);
		String imgfname = Prop.get(this,text+"Image");
		JButton button = null;
		if(imgfname.equals("NONE")) {
			button = new JButton(buttonText);
		} else {
			ImageIcon ii = ImageHandler.createImageIcon(imgfname);
			//button = new JButton(new ImageIcon("images/"+imgfname));
			button = new JButton(ii);
			button.setMargin(new java.awt.Insets(2,2,2,2));
			button.setToolTipText(buttonText);
		}
		button.addActionListener(actionListener);
		button.setActionCommand(text);
		add(button);
		return button;
	}
}
