/*
 * Created on 08.12.2003 17:44:47
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package generation;

import mauda.generation.*;
import mauda.operation.*;
import mauda.plugin.*;

/**
 * The pane for storage of the operations from which to generate
 * the todo-operations for the exercise
 * 
 * @author Markus Krebs
 */
public class AutoGenTab extends OpTemplateTab {

	protected static final String tabName = "AutoGen";

	protected String autogenFilename = "autogen.xml";	// Dateiname fr Laden/Speichern

	/**
	 * Constructs a panel to view the operations
	 * @param exercise GenExercise
	 */
	public AutoGenTab(GenExercise exercise) {
		super(exercise);
		setTabName(tabName);
		updateSettings();
	}
	protected void executePressed(GenExercise ex) {
		OperationQueue oq = GeneralAnalyst.autoGen(ex.getDSObject(), operationQueue, ex.getDifficulty(), ex.getMode());
		if(oq==null) { showNotSupportedDialog(); return; }
		exercise.commit(oq);
	}
	protected void updateSettings() {
		super.updateSettings();
		setDataFilename(autogenFilename);
		loadConfig(dataFilename);		
	}
}
