/*
 * Created on 07.12.2003 15:43:56
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package generation;

import mauda.*;
import mauda.generation.*;
import mauda.operation.*;
import mauda.utils.Prop;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Base-panel-template for ExerciseTab, RatingsTab, InitTab, 
 * ScrambleTab and AutoGenTab
 * 
 * @author Markus Krebs
 */
public class EditTab extends JPanel implements ActionListener, ExerciseUpdateListener {
	
	protected String dataFilename = null;	// Dateiname fr Laden/Speichern

	private JPanel buttonPanel;
	private String tabName;
	private String tabID;
	
	protected GenExercise exercise;
			
	/**
	 * Constructs an EditTab
	 * @param exercise
	 */
	public EditTab(GenExercise exercise) {
		
		tabName = "?";
		
		buttonPanel = new JPanel();
		
		buttonPanel.setLayout(new GridLayout(0,2));	// 2 Spalten (Zeilen egal)
		setLayout(new BorderLayout());
		
		add(buttonPanel, BorderLayout.SOUTH);
		
		this.exercise = exercise;
		
		//topComponent = null;
	}
	/**
	 * Sets the top-panel of the EditTab.
	 * Attention: This method should only called once from sub-
	 * classes.
	 * @param comp
	 */
	protected void setTopPanel(JComponent comp) {
		//if(topComponent!=null) remove(topComponent);
		add(comp, BorderLayout.CENTER);
		//topComponent = comp;
	}
	// Button hinzufgen
	protected JButton createButton(String text) {
		String buttonText = Prop.get(this, tabID+text);
		JButton button = new JButton(buttonText);
		button.addActionListener(this);
		button.setActionCommand(text);
		buttonPanel.add(button);
		return button;
	}
	// Name des Tabs (fr JTabbedPane)
	protected String getTabName() {
		return tabName;
	}
	
	protected void setTabName(String s) {
		tabName = Prop.get(this, s+"TabName");
		tabID = s;
	}
	// Ausgabe fr JList generieren (Vector umkehren)
	protected Vector prepareForList(OperationQueue oq, int initialCounter) {
		Vector vec = new Vector();
		int counter = initialCounter;
		Enumeration en = oq.toVector().elements();
		while(en.hasMoreElements()) {
			counter++;
			vec.add(0, counter+". "+en.nextElement());
		}
		return vec;
	}
	// Ausgabe fr JList generieren (Vector umkehren)
	protected Vector prepareForList(Vector operations, int initialCounter) {
		Vector vec = new Vector();
		int counter = initialCounter;
		int subCounter = 0;
		Enumeration en = operations.elements();
		while(en.hasMoreElements()) {
			SimpleOperation so = (SimpleOperation)en.nextElement();
			if(so instanceof Operation) {
				subCounter = 0;
				counter++;
				vec.add(0, counter+". "+so);
			} else if(so instanceof SubOperation) {
				subCounter++;
				vec.add(0, "      "+subCounter+". "+so);
			}
		}
		return vec;
	}
	/* (non-Javadoc)
	 * @see mauda.ExerciseUpdateListener#exerciseUpdate(mauda.ExerciseUpdateEvent)
	 */
	public void exerciseUpdate(ExerciseUpdateEvent e) {
		if(e.dsChanged()) update();
		if(e.getID() == ExerciseUpdateEvent.PLUGIN_CHANGED)
			updateSettings();
	}
	// Ansicht aktualisieren, aber nur wenn Komponente sichtbar ist
	protected void update() {
		if(isVisible()) doUpdate();
	}
	// Wird ausgefhrt, wenn wirklich ein Update notwendig ist
	// (muss von der berklasse berschrieben werden)
	protected void doUpdate() {
	}
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		// Muss von der berklasse berschrieben werden, damit auf Buttons reagiert
		// wird		
	}
	
	// Dateioperation wirklich ausfhren-Dialog
	protected boolean dialog(String operation) {
		String s = Prop.get(this, "EditTabDialogLoadSave");
		s = s.replaceAll("OPERATION", operation);
		int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), s, Prop.get(this, "EditTabDialogLoadSaveTitle"), JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.WARNING_MESSAGE);
		if(result == JOptionPane.YES_OPTION) { return true; }
		//else if(result == JOptionPane.NO_OPTION) { return false; }
		//else if(result == JOptionPane.CANCEL_OPTION) { return false; }
		return false;
	}
	protected void setDataFilename(String f) {
		dataFilename = exercise.getDataDirectory() + f;
	}
	
	// Anzeige wenn ein Feature nicht untersttzt wird
	protected void showNotSupportedDialog() {
		String msg = "This operation is not supported for Mode:\n"+
						ExerciseMode.getString(exercise.getMode());
		javax.swing.JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), msg);
	}
	protected void updateSettings() {}
}
