/*
 * Created on 07.12.2003 15:48:49
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package generation;

import mauda.*;
import mauda.operation.*;
import mauda.treeoperationview.*;
import mauda.generation.GenExercise;
 
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
/**
 * The pane for visualisation of exercise init- and todo-operations
 * 
 * @author Markus Krebs
 */
public class ExerciseTab extends EditTab { //implements ListSelectionListener {
	
	protected static final String tabName = "Exercise";
	protected static final String startExercise = "StartEx";
	protected static final String upExercisePoint = "Up";
	protected static final String downExercisePoint = "Down";
	protected static final String checkExercise = "Check";
	
	protected static final String clearFollowing = "Clear following operations...";
	protected static final String showSubOperations = "Show Suboperations...";
	
	/**
	 * Creates a ExerciseTab
	 * @param exercise GenExercise
	 */
	public ExerciseTab(GenExercise exercise) {
		super(exercise);

		setTabName(tabName);
		
		setTopPanel(exercise.getTreeOperationView().getPanel());
		
		// Button-Teil
		createButton(upExercisePoint);
		createButton(downExercisePoint);
		createButton(startExercise);
		createButton(checkExercise);
		
		// Im TreeOperationView MenuItems hinzufgen
		NodePopup np = exercise.getTreeOperationView().getNodePopup();
		np.addItem(clearFollowing, this);
		np.addItem(showSubOperations, this);
	}
	protected void doUpdate() {
		//updateLists();
		actualizeTree();
	}
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(!exercise.actionsAllowed()) return;
		String s = e.getActionCommand();
		OperationRecorder or = exercise.getOperationRecorder();
		if(s == startExercise) {
			or.goInTodoMode();
			// NEU (folgende 2 Zeilen neu)
			int p = or.getTodoPosition();
			or.setTodoPosition(or.getPossibleTodoPosition(p));
			actualizeTree();
		} else if(s == upExercisePoint) {
			or.decreaseTodoPosition();
			actualizeTree();
		} else if(s == downExercisePoint) {
			or.increaseTodoPosition();
			actualizeTree();
		} else if(s == checkExercise) {
			String result = exercise.isReadyToSave();
			if(result.equals("OK")&&exercise.getMode() == ExerciseMode.FAULT) {
				Failure f = exercise.getOperationRecorder().getUnlimitedFailure(0);
				JPanel p = new JPanel();
				p.setLayout(new BorderLayout());
				JTextArea ta = new JTextArea(f.getDescriptionString(), 16, 60);
				ta.setEditable(false);
				ta.setFont(new Font("Monospaced", Font.PLAIN, 12));
				p.add(new JLabel("FAILURE FOUND:"), BorderLayout.NORTH);
				p.add(new JScrollPane(ta), BorderLayout.CENTER);
				p.add(new JLabel("Exercise is ready for saving."), BorderLayout.SOUTH);
				JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), p);
			} else
				JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), result);
		} else if(s == clearFollowing) {
			// Sicherheitsabfrage
			//String msg = "Really?\n\nThis action can not be undoed!";
			//int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), msg, "Clear following Operations", JOptionPane.OK_CANCEL_OPTION);
			//if(result != JOptionPane.OK_OPTION) return;
			Vector v = new Vector();
			// Zu dem Index springen ...
			ExerciseUpdateEvent eue = new ExerciseUpdateEvent(exercise, ExerciseUpdateEvent.JUMP);
			int index = exercise.getTreeOperationView().getActionIndex();
			int delta = index+or.getOffset(0,-1) - or.getCurrentOffset(); 
			eue.setValue(delta);
			v.add(eue);
			// und dann CLEAR_FOLLOWING
			eue = new ExerciseUpdateEvent(exercise, ExerciseUpdateEvent.CLEAR_FOLLOWING);
			v.add(eue);
			exercise.commit(v);
		} else if(s == showSubOperations) {
			showSubOperations(exercise.getTreeOperationView().getActionIndex());
		}
		update();
	}
	private void actualizeTree() {
		((GenExercise)exercise).getTreeOperationView().markTodoPosition();
	}
	
	private void showSubOperations(int index) {
		OperationRecorder or = exercise.getOperationRecorder();
		Object op = or.getEntry(index + or.getOffset(0,-1));
		if(op!=null && op instanceof Operation) {
			// Umgekehrte Ausgabe der SubOperationen
			Vector v = new Vector();
			SubOperationQueue soq = ((Operation)op).getSubOperationQueue();
			for(int i=0; i<soq.length(); i++) {
				v.add(""+((i+1)<10?" ":"")+(i+1)+". "+soq.get(i));
			}
			JFrame frame = new JFrame();
			//JWindow frame = new JWindow();
			frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
			java.awt.Container contentPane = frame.getContentPane();
			contentPane.setLayout(new BorderLayout());
			JLabel opLabel = new JLabel(op+"");
			JList list = new JList();
			list.setListData(v);
			JButton okButton = new JButton("OK");
			okButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					Object o = e.getSource();
					while(o!=null&&!(o instanceof Window)) o = ((Container)o).getParent();
					if(o!=null) ((Window)o).dispose();
					else System.out.println("Window not found!");
				}});
			contentPane.add(opLabel, BorderLayout.NORTH);
			contentPane.add(new JScrollPane(list), BorderLayout.CENTER);
			contentPane.add(okButton, BorderLayout.SOUTH);
			frame.setTitle("SubOperations");
			frame.setBounds(MAUDA.getRelativeBounds(200,250));
			//frame.setBounds(200,200,200,250);
			frame.setVisible(true);
		}		
	}
	
}
