/*
 * Created on 08.12.2003 16:40:55
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package generation;

import mauda.*;
import mauda.generation.*;
import mauda.operation.*;
import mauda.utils.Prop;

import javax.swing.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

/**
 * The base-pane-template for InitTab, ScrambleTab and AutoGenTab
 * 
 * @author Markus Krebs
 */
public class OpTemplateTab extends EditTab {

	private JList list;
	
	/**
	 * Stores the operations for this Tab.
	 */
	public OperationQueue operationQueue;
	
	protected static final String tabName = "OpTemplate";
	protected static final String execute = "Execute";
	protected static final String load = "Load";
	protected static final String save = "Save";	
	protected static final String add = "Add";
	protected static final String remove = "Remove";
	protected static final String clear = "Clear";
	
	protected static final String addMessageTitle = "AddMessageTitle";	
	protected static final String addMessage = "AddMessage";

	/**
	 * Creates a OpTemplateTab
	 * @param exercise
	 */
	public OpTemplateTab(GenExercise exercise) {
		super(exercise);
		setTabName(tabName);
		
		operationQueue = new OperationQueue();
		
		list = new JList(new Vector());
		setTopPanel(new JScrollPane(list));

		createButton(execute);
		createButton(clear);
		createButton(add);
		createButton(remove);
		createButton(load);
		createButton(save);
	}
	// Ansicht aktualisieren, aber nur wenn Komponente sichtbar ist
	protected void update() {
		if(isVisible()) {
			// Instanziierungen lschen
			OperationQueue oq = new OperationQueue();
			Enumeration en = operationQueue.toVector().elements();
			while(en.hasMoreElements()) {
				oq.add(((Operation)en.nextElement()).getID());			
			}
			operationQueue = oq;
			doUpdate();
		}
	}
	
	protected void doUpdate() {
		Vector v = operationQueue.toVector();
		// Roh-Ansicht
		//list.setListData(v);
		// Nummerierte Ansicht
		Vector listData = new Vector();
		int counter = 0;
		Enumeration en = v.elements();
		while(en.hasMoreElements()) {
			counter++;
			Operation op = (Operation)en.nextElement();
			listData.add(counter+". "+op);
		}
		list.setListData(listData);
		/*
		// Komprimierte Ansicht
		// Achtung: Remove funktioniert dann nicht mehr richtig
		HashMap hm = new HashMap();
		Enumeration en = v.elements();
		while(en.hasMoreElements()) {
			int opid = ((Operation)en.nextElement()).getOperation();
			Integer integer = new Integer(opid);
			int c = 0;
			if(hm.containsKey(integer)) c = ((Integer)hm.get(integer)).intValue();
			hm.put(integer, new Integer(c+1)); 
		}
		Vector listData = new Vector();
		Iterator it = hm.keySet().iterator();
		while(it.hasNext()) {
			Integer key = (Integer)it.next(); 
			int opid = key.intValue();
			int cnt = ((Integer)hm.get(key)).intValue();
			Operation op = new Operation(opid);
			listData.add(cnt+": "+op);
		}
		list.setListData(listData);
		*/
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(!exercise.actionsAllowed()) return;
		String s = e.getActionCommand();
		if(s == execute) {
			executePressed(exercise);
		} else if(s == add) {
			JPanel inputPanel = new JPanel();
			inputPanel.setLayout(new BorderLayout());
			inputPanel.add(new JLabel(Prop.get(this, "OpTemplate"+addMessage)), BorderLayout.NORTH);
			JPanel p = new JPanel();
			JTextField textField = new JTextField("1",2);
			//textField.setSelectionStart(0);
			//textField.setSelectionEnd(1);
			//textField.requestFocus();		
			p.add(textField);
			ButtonGroup g = new ButtonGroup();
			
			Vector aop = exercise.getAvailableOperations();
			int size = aop.size();
			JRadioButton[] rbs = new JRadioButton[size];
			for(int i=0; i<size; i++) {
				rbs[i] = new JRadioButton(aop.elementAt(i)+"");
				g.add(rbs[i]);
				p.add(rbs[i]);
			}
			inputPanel.add(p, BorderLayout.CENTER);
			int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(),
								inputPanel, 
								Prop.get(this, "OpTemplate"+addMessageTitle),
								JOptionPane.OK_CANCEL_OPTION);
			if(result == JOptionPane.OK_OPTION) {
				Operation op = null;
				for(int i=0; i<size; i++)
					if(rbs[i].isSelected()) { op = (Operation)aop.elementAt(i); break; }
				if(op!=null) {
					int times = Integer.parseInt(textField.getText());
					for(int i=0; i<times; i++) operationQueue.add((Operation)op.clone()); 
				}
			}
		} else if(s == remove) {
			int[] indices = list.getSelectedIndices();
			if(indices.length<=0) return;
			for(int i=indices.length-1; i>=0; i--)
				operationQueue.remove(indices[i]);
			/*
			int index = list.getSelectedIndex();
			if (index < 0)
				return;
			operationQueue.remove(index);
			*/			
		} else if(s == clear) {
			operationQueue = new OperationQueue();
		} else if(s == load) {
			if(dialog("LOAD "+dataFilename)) loadConfig(dataFilename);
		} else if(s == save) {
			if(dialog("SAVE "+dataFilename)) {
				Vector savevev = new Vector();
				savevev.add(operationQueue.save());
				boolean result = XMLFileAccess.save(dataFilename, savevev);
				if(!result) JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant save file: '"+dataFilename+"' !\n\n"+
									"--> File not saved!");
			} 
		}
		update();
	}
	protected void loadConfig(String filename) {
		Vector v = XMLFileAccess.load(filename);
		if(v==null) {
			JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant load '"+filename+"'!");
			return;
		} 
		OperationQueue oq = new OperationQueue();
		oq.load((Vector)v.firstElement());
		operationQueue = oq;
		update();
	}
	// Diese beiden Methoden mssen von der berklasse berschrieben werden
	protected void executePressed(GenExercise ex) { }
	protected void defaultPressed(GenExercise ex) { }
	protected void updateSettings() {
		// Anzeige leeren
		operationQueue = new OperationQueue();
		update();
	}
	
}
