/*
 * Created on 08.01.2004 13:52:46
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package generation;

import mauda.MAUDA;
import mauda.generation.*;
import mauda.operation.*;
import mauda.plugin.*;
import mauda.utils.Prop;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import jedas.*;
/**
 * pane for displaying the currently possible operations,
 * sorted both by name and by rating
 * 
 * @author Markus Krebs
 */
public class OperationsTab extends EditTab implements ListSelectionListener {
	
	private JList list1;
	private JList list2;
	private Operation[] operations1;
	private Operation[] operations2;
	
	private int lastListClicked = 0;

	protected static final String tabName = "Operations";
	protected static final String execute = "Execute";
	
	protected static final String sortedByRating = "SortedByRating";
	protected static final String sortedByName = "SortedByName";
	
	/**
	 * Constructs a panel to view the operations
	 * @param exercise GenExercise
	 */
	public OperationsTab(GenExercise exercise) {
		super(exercise);
		
		setTabName(tabName);
		
		// Oberer Teil
		java.util.Vector v = new java.util.Vector();
		v.add("Entry 1");
		
		JPanel p1 = new JPanel();
		p1.setLayout(new BorderLayout());
		p1.add(new JLabel(Prop.get(this, tabName+sortedByRating)), BorderLayout.NORTH);
		list1 = new JList(v);
		list1.addListSelectionListener(this);
		p1.add(new JScrollPane(list1), BorderLayout.CENTER);
		
		JPanel p2 = new JPanel();
		p2.setLayout(new BorderLayout());
		p2.add(new JLabel(Prop.get(this, tabName+sortedByName)), BorderLayout.NORTH);
		list2 = new JList(v);
		list2.addListSelectionListener(this);
		p2.add(new JScrollPane(list2), BorderLayout.CENTER);
		
		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		splitPane.setDividerLocation(170);
		splitPane.setLeftComponent(p1);
		splitPane.setRightComponent(p2);
		
		setTopPanel(splitPane);
		
		// Button-Teil
		createButton(execute);
	}
	protected void doUpdate() {
		updateLists();
	}
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(!exercise.actionsAllowed()) return;
		String s = e.getActionCommand();
		if(s == execute) {
			Operation op = null;
			if(lastListClicked == 1) {
				int index = list1.getSelectedIndex();
				if (index < 0) return;
				op = operations1[index];
			} else if(lastListClicked == 2) {
				int index = list2.getSelectedIndex();
				if (index < 0) return;
				op = operations2[index];
			}
			if(op!=null) {
				exercise.commit(op);
				//update();
			}
		}
		//update();
	}

	/* (non-Javadoc)
	 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
	 */
	public void valueChanged(ListSelectionEvent e) {
		int index = ((JList)e.getSource()).getSelectedIndex();
		if(index==-1) return;
		Operation op = null;
		if(e.getSource()==list1) {
			lastListClicked = 1;
			op = operations1[index];
		} 
		else if(e.getSource()==list2) {
			lastListClicked = 2;
			op = operations2[index];
		} 
		if(op!=null) {
			SubOperationQueue soq = op.getSubOperationQueue();
			String msg = op+"\n\n"+soq;
			JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), msg);
		}
		//((JList)e.getSource()).clearSelection();
	}

	protected void updateLists() {
		OperationQueue oq = GeneralAnalyst.getOperations(exercise.getDSObject());
		if(oq == null) {
			// getOperations in PLUGIN nicht verfgbar
			// ev. Visualisierte Fehlermeldung (not supported)
			list1.setListData(new Vector());
			list2.setListData(new Vector());
			return;
		}
				
		operations1 = oq.toArray();
		Operation.setSort(Operation.SORT_BY_RATING);
		Arrays.sort(operations1);
		
		operations2 = oq.toArray();
		Operation.setSort(Operation.SORT_BY_NAME);
		Arrays.sort(operations2);

		Vector listVec1 = new Vector();
		Vector listVec2 = new Vector();
		for (int i = 0; i < operations1.length; i++) {
			listVec1.add(operations1[i]);
			listVec2.add(operations2[i]);
		}

		list1.setListData(listVec1);
		list2.setListData(listVec2);
		/*
		statusLabel.setText(
			"Time: "
				+ GeneralAnalyst.calcTime
				+ "  #Op: "
				+ GeneralAnalyst.calcCount
				+ "  #Key: "
				+ GeneralAnalyst.keysCount);
		*/		
		Jedas.updateDisplay();
	}
}
